// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Configure this property to support the search service using either the Default Compute or Azure Confidential Compute.
 */
public final class ComputeType extends ExpandableStringEnum<ComputeType> {
    /**
     * Static value default for ComputeType.
     */
    public static final ComputeType DEFAULT = fromString("default");

    /**
     * Static value confidential for ComputeType.
     */
    public static final ComputeType CONFIDENTIAL = fromString("confidential");

    /**
     * Creates a new instance of ComputeType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ComputeType() {
    }

    /**
     * Creates or finds a ComputeType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ComputeType.
     */
    public static ComputeType fromString(String name) {
        return fromString(name, ComputeType.class);
    }

    /**
     * Gets known ComputeType values.
     * 
     * @return known ComputeType values.
     */
    public static Collection<ComputeType> values() {
        return values(ComputeType.class);
    }
}
