// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.search.fluent.NetworkSecurityPerimeterConfigurationsClient;
import com.azure.resourcemanager.search.fluent.models.NetworkSecurityPerimeterConfigurationInner;
import com.azure.resourcemanager.search.models.NetworkSecurityPerimeterConfigurationListResult;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * NetworkSecurityPerimeterConfigurationsClient.
 */
public final class NetworkSecurityPerimeterConfigurationsClientImpl
    implements NetworkSecurityPerimeterConfigurationsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final NetworkSecurityPerimeterConfigurationsService service;

    /**
     * The service client containing this operation class.
     */
    private final SearchManagementClientImpl client;

    /**
     * Initializes an instance of NetworkSecurityPerimeterConfigurationsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    NetworkSecurityPerimeterConfigurationsClientImpl(SearchManagementClientImpl client) {
        this.service = RestProxy.create(NetworkSecurityPerimeterConfigurationsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SearchManagementClientNetworkSecurityPerimeterConfigurations to be
     * used by the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "SearchManagementClientNetworkSecurityPerimeterConfigurations")
    public interface NetworkSecurityPerimeterConfigurationsService {
        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/networkSecurityPerimeterConfigurations")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NetworkSecurityPerimeterConfigurationListResult>> listByService(
            @HostParam("$host") String endpoint, @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/networkSecurityPerimeterConfigurations/{nspConfigName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NetworkSecurityPerimeterConfigurationInner>> get(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName, @PathParam("nspConfigName") String nspConfigName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/networkSecurityPerimeterConfigurations/{nspConfigName}/reconcile")
        @ExpectedResponses({ 202 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> reconcile(@HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName, @PathParam("nspConfigName") String nspConfigName,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<NetworkSecurityPerimeterConfigurationListResult>> listByServiceNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Gets a list of network security perimeter configurations for a search service.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of network security perimeter configurations for a search service along with {@link PagedResponse}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterConfigurationInner>>
        listByServiceSinglePageAsync(String resourceGroupName, String searchServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByService(this.client.getEndpoint(), resourceGroupName,
                searchServiceName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .<PagedResponse<NetworkSecurityPerimeterConfigurationInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a list of network security perimeter configurations for a search service.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of network security perimeter configurations for a search service along with {@link PagedResponse}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterConfigurationInner>>
        listByServiceSinglePageAsync(String resourceGroupName, String searchServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByService(this.client.getEndpoint(), resourceGroupName, searchServiceName,
                this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Gets a list of network security perimeter configurations for a search service.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of network security perimeter configurations for a search service as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<NetworkSecurityPerimeterConfigurationInner> listByServiceAsync(String resourceGroupName,
        String searchServiceName) {
        return new PagedFlux<>(() -> listByServiceSinglePageAsync(resourceGroupName, searchServiceName),
            nextLink -> listByServiceNextSinglePageAsync(nextLink));
    }

    /**
     * Gets a list of network security perimeter configurations for a search service.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of network security perimeter configurations for a search service as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<NetworkSecurityPerimeterConfigurationInner> listByServiceAsync(String resourceGroupName,
        String searchServiceName, Context context) {
        return new PagedFlux<>(() -> listByServiceSinglePageAsync(resourceGroupName, searchServiceName, context),
            nextLink -> listByServiceNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets a list of network security perimeter configurations for a search service.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of network security perimeter configurations for a search service as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterConfigurationInner> listByService(String resourceGroupName,
        String searchServiceName) {
        return new PagedIterable<>(listByServiceAsync(resourceGroupName, searchServiceName));
    }

    /**
     * Gets a list of network security perimeter configurations for a search service.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of network security perimeter configurations for a search service as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<NetworkSecurityPerimeterConfigurationInner> listByService(String resourceGroupName,
        String searchServiceName, Context context) {
        return new PagedIterable<>(listByServiceAsync(resourceGroupName, searchServiceName, context));
    }

    /**
     * Gets a network security perimeter configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a network security perimeter configuration along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<NetworkSecurityPerimeterConfigurationInner>> getWithResponseAsync(String resourceGroupName,
        String searchServiceName, String nspConfigName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (nspConfigName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nspConfigName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName,
                nspConfigName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a network security perimeter configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a network security perimeter configuration along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<NetworkSecurityPerimeterConfigurationInner>> getWithResponseAsync(String resourceGroupName,
        String searchServiceName, String nspConfigName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (nspConfigName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nspConfigName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), resourceGroupName, searchServiceName, nspConfigName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Gets a network security perimeter configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a network security perimeter configuration on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<NetworkSecurityPerimeterConfigurationInner> getAsync(String resourceGroupName, String searchServiceName,
        String nspConfigName) {
        return getWithResponseAsync(resourceGroupName, searchServiceName, nspConfigName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Gets a network security perimeter configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a network security perimeter configuration along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<NetworkSecurityPerimeterConfigurationInner> getWithResponse(String resourceGroupName,
        String searchServiceName, String nspConfigName, Context context) {
        return getWithResponseAsync(resourceGroupName, searchServiceName, nspConfigName, context).block();
    }

    /**
     * Gets a network security perimeter configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a network security perimeter configuration.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public NetworkSecurityPerimeterConfigurationInner get(String resourceGroupName, String searchServiceName,
        String nspConfigName) {
        return getWithResponse(resourceGroupName, searchServiceName, nspConfigName, Context.NONE).getValue();
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> reconcileWithResponseAsync(String resourceGroupName,
        String searchServiceName, String nspConfigName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (nspConfigName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nspConfigName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.reconcile(this.client.getEndpoint(), resourceGroupName, searchServiceName,
                nspConfigName, this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reconcileWithResponseAsync(String resourceGroupName,
        String searchServiceName, String nspConfigName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (nspConfigName == null) {
            return Mono.error(new IllegalArgumentException("Parameter nspConfigName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.reconcile(this.client.getEndpoint(), resourceGroupName, searchServiceName, nspConfigName,
            this.client.getSubscriptionId(), this.client.getApiVersion(), accept, context);
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginReconcileAsync(String resourceGroupName, String searchServiceName,
        String nspConfigName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = reconcileWithResponseAsync(resourceGroupName, searchServiceName, nspConfigName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginReconcileAsync(String resourceGroupName, String searchServiceName,
        String nspConfigName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = reconcileWithResponseAsync(resourceGroupName, searchServiceName, nspConfigName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReconcile(String resourceGroupName, String searchServiceName,
        String nspConfigName) {
        return this.beginReconcileAsync(resourceGroupName, searchServiceName, nspConfigName).getSyncPoller();
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReconcile(String resourceGroupName, String searchServiceName,
        String nspConfigName, Context context) {
        return this.beginReconcileAsync(resourceGroupName, searchServiceName, nspConfigName, context).getSyncPoller();
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> reconcileAsync(String resourceGroupName, String searchServiceName, String nspConfigName) {
        return beginReconcileAsync(resourceGroupName, searchServiceName, nspConfigName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> reconcileAsync(String resourceGroupName, String searchServiceName, String nspConfigName,
        Context context) {
        return beginReconcileAsync(resourceGroupName, searchServiceName, nspConfigName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void reconcile(String resourceGroupName, String searchServiceName, String nspConfigName) {
        reconcileAsync(resourceGroupName, searchServiceName, nspConfigName).block();
    }

    /**
     * Reconcile network security perimeter configuration for the Azure AI Search resource provider. This triggers a
     * manual resync with network security perimeter configurations by ensuring the search service carries the latest
     * configuration.
     * 
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     * value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure AI Search service associated with the specified resource group.
     * @param nspConfigName The network security perimeter configuration name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void reconcile(String resourceGroupName, String searchServiceName, String nspConfigName, Context context) {
        reconcileAsync(resourceGroupName, searchServiceName, nspConfigName, context).block();
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of a list NSP (network security perimeter) configurations request along with {@link PagedResponse}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterConfigurationInner>>
        listByServiceNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByServiceNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<NetworkSecurityPerimeterConfigurationInner>>map(
                res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                    res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of a list NSP (network security perimeter) configurations request along with {@link PagedResponse}
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<NetworkSecurityPerimeterConfigurationInner>>
        listByServiceNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByServiceNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
