// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.fluent.models.SearchServiceInner;
import java.io.IOException;
import java.util.List;

/**
 * Response containing a list of search services.
 */
@Immutable
public final class SearchServiceListResult implements JsonSerializable<SearchServiceListResult> {
    /*
     * The list of search services.
     */
    private List<SearchServiceInner> value;

    /*
     * Request URL that can be used to query next page of search services. Returned when the total number of requested
     * search services exceed maximum page size.
     */
    private String nextLink;

    /**
     * Creates an instance of SearchServiceListResult class.
     */
    public SearchServiceListResult() {
    }

    /**
     * Get the value property: The list of search services.
     * 
     * @return the value value.
     */
    public List<SearchServiceInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of search services. Returned when the
     * total number of requested search services exceed maximum page size.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SearchServiceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SearchServiceListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SearchServiceListResult.
     */
    public static SearchServiceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SearchServiceListResult deserializedSearchServiceListResult = new SearchServiceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SearchServiceInner> value = reader.readArray(reader1 -> SearchServiceInner.fromJson(reader1));
                    deserializedSearchServiceListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSearchServiceListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSearchServiceListResult;
        });
    }
}
