// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.search.fluent.models.QuotaUsageResultInner;
import java.io.IOException;
import java.util.List;

/**
 * Response containing the quota usage information for all the supported SKUs of Azure AI Search.
 */
@Immutable
public final class QuotaUsagesListResult implements JsonSerializable<QuotaUsagesListResult> {
    /*
     * The quota usages for the SKUs supported by Azure AI Search.
     */
    private List<QuotaUsageResultInner> value;

    /*
     * Request URL that can be used to query next page of quota usages. Returned when the total number of requested
     * quota usages exceed maximum page size.
     */
    private String nextLink;

    /**
     * Creates an instance of QuotaUsagesListResult class.
     */
    public QuotaUsagesListResult() {
    }

    /**
     * Get the value property: The quota usages for the SKUs supported by Azure AI Search.
     * 
     * @return the value value.
     */
    public List<QuotaUsageResultInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: Request URL that can be used to query next page of quota usages. Returned when the
     * total number of requested quota usages exceed maximum page size.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of QuotaUsagesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of QuotaUsagesListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the QuotaUsagesListResult.
     */
    public static QuotaUsagesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            QuotaUsagesListResult deserializedQuotaUsagesListResult = new QuotaUsagesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<QuotaUsageResultInner> value
                        = reader.readArray(reader1 -> QuotaUsageResultInner.fromJson(reader1));
                    deserializedQuotaUsagesListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedQuotaUsagesListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedQuotaUsagesListResult;
        });
    }
}
