// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

/**
 * Describes what response the data plane API of a search service would send for requests that failed authentication.
 */
public enum AadAuthFailureMode {
    /**
     * Enum value http403.
     */
    HTTP403("http403"),

    /**
     * Enum value http401WithBearerChallenge.
     */
    HTTP401WITH_BEARER_CHALLENGE("http401WithBearerChallenge");

    /**
     * The actual serialized value for a AadAuthFailureMode instance.
     */
    private final String value;

    AadAuthFailureMode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AadAuthFailureMode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed AadAuthFailureMode object, or null if unable to parse.
     */
    public static AadAuthFailureMode fromString(String value) {
        if (value == null) {
            return null;
        }
        AadAuthFailureMode[] items = AadAuthFailureMode.values();
        for (AadAuthFailureMode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
