// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The name of the SKU supported by Azure AI Search. */
@Fluent
public final class QuotaUsageResultName {
    /*
     * The SKU name supported by Azure AI Search.
     */
    @JsonProperty(value = "value")
    private String value;

    /*
     * The localized string value for the SKU name.
     */
    @JsonProperty(value = "localizedValue")
    private String localizedValue;

    /** Creates an instance of QuotaUsageResultName class. */
    public QuotaUsageResultName() {
    }

    /**
     * Get the value property: The SKU name supported by Azure AI Search.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: The SKU name supported by Azure AI Search.
     *
     * @param value the value value to set.
     * @return the QuotaUsageResultName object itself.
     */
    public QuotaUsageResultName withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the localizedValue property: The localized string value for the SKU name.
     *
     * @return the localizedValue value.
     */
    public String localizedValue() {
        return this.localizedValue;
    }

    /**
     * Set the localizedValue property: The localized string value for the SKU name.
     *
     * @param localizedValue the localizedValue value to set.
     * @return the QuotaUsageResultName object itself.
     */
    public QuotaUsageResultName withLocalizedValue(String localizedValue) {
        this.localizedValue = localizedValue;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
