// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to
 * 'disabled', traffic over public interface is not allowed, and private endpoint connections would be the exclusive
 * access method.
 */
public enum PublicNetworkAccess {
    /** Enum value enabled. */
    ENABLED("enabled"),

    /** Enum value disabled. */
    DISABLED("disabled");

    /** The actual serialized value for a PublicNetworkAccess instance. */
    private final String value;

    PublicNetworkAccess(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a PublicNetworkAccess instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed PublicNetworkAccess object, or null if unable to parse.
     */
    @JsonCreator
    public static PublicNetworkAccess fromString(String value) {
        if (value == null) {
            return null;
        }
        PublicNetworkAccess[] items = PublicNetworkAccess.values();
        for (PublicNetworkAccess item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
