// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the options for how the search service authenticates a data plane request. This cannot be set if
 * 'disableLocalAuth' is set to true.
 */
@Fluent
public final class DataPlaneAuthOptions {
    /*
     * Indicates that only the API key can be used for authentication.
     */
    @JsonProperty(value = "apiKeyOnly")
    private Object apiKeyOnly;

    /*
     * Indicates that either the API key or an access token from a Microsoft Entra ID tenant can be used for
     * authentication.
     */
    @JsonProperty(value = "aadOrApiKey")
    private DataPlaneAadOrApiKeyAuthOption aadOrApiKey;

    /** Creates an instance of DataPlaneAuthOptions class. */
    public DataPlaneAuthOptions() {
    }

    /**
     * Get the apiKeyOnly property: Indicates that only the API key can be used for authentication.
     *
     * @return the apiKeyOnly value.
     */
    public Object apiKeyOnly() {
        return this.apiKeyOnly;
    }

    /**
     * Set the apiKeyOnly property: Indicates that only the API key can be used for authentication.
     *
     * @param apiKeyOnly the apiKeyOnly value to set.
     * @return the DataPlaneAuthOptions object itself.
     */
    public DataPlaneAuthOptions withApiKeyOnly(Object apiKeyOnly) {
        this.apiKeyOnly = apiKeyOnly;
        return this;
    }

    /**
     * Get the aadOrApiKey property: Indicates that either the API key or an access token from a Microsoft Entra ID
     * tenant can be used for authentication.
     *
     * @return the aadOrApiKey value.
     */
    public DataPlaneAadOrApiKeyAuthOption aadOrApiKey() {
        return this.aadOrApiKey;
    }

    /**
     * Set the aadOrApiKey property: Indicates that either the API key or an access token from a Microsoft Entra ID
     * tenant can be used for authentication.
     *
     * @param aadOrApiKey the aadOrApiKey value to set.
     * @return the DataPlaneAuthOptions object itself.
     */
    public DataPlaneAuthOptions withAadOrApiKey(DataPlaneAadOrApiKeyAuthOption aadOrApiKey) {
        this.aadOrApiKey = aadOrApiKey;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (aadOrApiKey() != null) {
            aadOrApiKey().validate();
        }
    }
}
