// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Indicates that either the API key or an access token from a Microsoft Entra ID tenant can be used for authentication.
 */
@Fluent
public final class DataPlaneAadOrApiKeyAuthOption {
    /*
     * Describes what response the data plane API of a search service would send for requests that failed
     * authentication.
     */
    @JsonProperty(value = "aadAuthFailureMode")
    private AadAuthFailureMode aadAuthFailureMode;

    /** Creates an instance of DataPlaneAadOrApiKeyAuthOption class. */
    public DataPlaneAadOrApiKeyAuthOption() {
    }

    /**
     * Get the aadAuthFailureMode property: Describes what response the data plane API of a search service would send
     * for requests that failed authentication.
     *
     * @return the aadAuthFailureMode value.
     */
    public AadAuthFailureMode aadAuthFailureMode() {
        return this.aadAuthFailureMode;
    }

    /**
     * Set the aadAuthFailureMode property: Describes what response the data plane API of a search service would send
     * for requests that failed authentication.
     *
     * @param aadAuthFailureMode the aadAuthFailureMode value to set.
     * @return the DataPlaneAadOrApiKeyAuthOption object itself.
     */
    public DataPlaneAadOrApiKeyAuthOption withAadAuthFailureMode(AadAuthFailureMode aadAuthFailureMode) {
        this.aadAuthFailureMode = aadAuthFailureMode;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
