// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes a policy that determines how resources within the search service are to be encrypted with customer=managed
 * keys.
 */
@Fluent
public final class EncryptionWithCmk {
    /*
     * Describes how a search service should enforce having one or more non-customer-encrypted resources.
     */
    @JsonProperty(value = "enforcement")
    private SearchEncryptionWithCmk enforcement;

    /*
     * Describes whether the search service is compliant or not with respect to having non-customer-encrypted
     * resources. If a service has more than one non-customer-encrypted resource and 'Enforcement' is 'enabled' then
     * the service will be marked as 'nonCompliant'.
     */
    @JsonProperty(value = "encryptionComplianceStatus", access = JsonProperty.Access.WRITE_ONLY)
    private SearchEncryptionComplianceStatus encryptionComplianceStatus;

    /** Creates an instance of EncryptionWithCmk class. */
    public EncryptionWithCmk() {
    }

    /**
     * Get the enforcement property: Describes how a search service should enforce having one or more
     * non-customer-encrypted resources.
     *
     * @return the enforcement value.
     */
    public SearchEncryptionWithCmk enforcement() {
        return this.enforcement;
    }

    /**
     * Set the enforcement property: Describes how a search service should enforce having one or more
     * non-customer-encrypted resources.
     *
     * @param enforcement the enforcement value to set.
     * @return the EncryptionWithCmk object itself.
     */
    public EncryptionWithCmk withEnforcement(SearchEncryptionWithCmk enforcement) {
        this.enforcement = enforcement;
        return this;
    }

    /**
     * Get the encryptionComplianceStatus property: Describes whether the search service is compliant or not with
     * respect to having non-customer-encrypted resources. If a service has more than one non-customer-encrypted
     * resource and 'Enforcement' is 'enabled' then the service will be marked as 'nonCompliant'.
     *
     * @return the encryptionComplianceStatus value.
     */
    public SearchEncryptionComplianceStatus encryptionComplianceStatus() {
        return this.encryptionComplianceStatus;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
