// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.search.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.search.fluent.SharedPrivateLinkResourcesClient;
import com.azure.resourcemanager.search.fluent.models.SharedPrivateLinkResourceInner;
import com.azure.resourcemanager.search.models.SharedPrivateLinkResourceListResult;
import com.azure.resourcemanager.search.models.SharedPrivateLinkResourceProperties;
import java.nio.ByteBuffer;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in SharedPrivateLinkResourcesClient. */
public final class SharedPrivateLinkResourcesClientImpl implements SharedPrivateLinkResourcesClient {
    private final ClientLogger logger = new ClientLogger(SharedPrivateLinkResourcesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final SharedPrivateLinkResourcesService service;

    /** The service client containing this operation class. */
    private final SearchManagementClientImpl client;

    /**
     * Initializes an instance of SharedPrivateLinkResourcesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    SharedPrivateLinkResourcesClientImpl(SearchManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    SharedPrivateLinkResourcesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for SearchManagementClientSharedPrivateLinkResources to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "SearchManagementClie")
    private interface SharedPrivateLinkResourcesService {
        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search"
                + "/searchServices/{searchServiceName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName,
            @PathParam("sharedPrivateLinkResourceName") String sharedPrivateLinkResourceName,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @BodyParam("application/json") SharedPrivateLinkResourceInner sharedPrivateLinkResource,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search"
                + "/searchServices/{searchServiceName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SharedPrivateLinkResourceInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName,
            @PathParam("sharedPrivateLinkResourceName") String sharedPrivateLinkResourceName,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search"
                + "/searchServices/{searchServiceName}/sharedPrivateLinkResources/{sharedPrivateLinkResourceName}")
        @ExpectedResponses({202, 204, 404})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName,
            @PathParam("sharedPrivateLinkResourceName") String sharedPrivateLinkResourceName,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search"
                + "/searchServices/{searchServiceName}/sharedPrivateLinkResources")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SharedPrivateLinkResourceListResult>> listByService(
            @HostParam("$host") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("searchServiceName") String searchServiceName,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<SharedPrivateLinkResourceListResult>> listByServiceNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("x-ms-client-request-id") UUID clientRequestId,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        SharedPrivateLinkResourceProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        final String accept = "application/json";
        SharedPrivateLinkResourceInner sharedPrivateLinkResource = new SharedPrivateLinkResourceInner();
        sharedPrivateLinkResource.withProperties(properties);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .createOrUpdate(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            searchServiceName,
                            sharedPrivateLinkResourceName,
                            clientRequestId,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            sharedPrivateLinkResource,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        SharedPrivateLinkResourceProperties properties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        final String accept = "application/json";
        SharedPrivateLinkResourceInner sharedPrivateLinkResource = new SharedPrivateLinkResourceInner();
        sharedPrivateLinkResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return service
            .createOrUpdate(
                this.client.getEndpoint(),
                resourceGroupName,
                searchServiceName,
                sharedPrivateLinkResourceName,
                clientRequestId,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                sharedPrivateLinkResource,
                accept,
                context);
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<SharedPrivateLinkResourceInner>, SharedPrivateLinkResourceInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String searchServiceName,
            String sharedPrivateLinkResourceName,
            UUID clientRequestId,
            SharedPrivateLinkResourceProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties);
        return this
            .client
            .<SharedPrivateLinkResourceInner, SharedPrivateLinkResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                SharedPrivateLinkResourceInner.class,
                SharedPrivateLinkResourceInner.class,
                this.client.getContext());
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<SharedPrivateLinkResourceInner>, SharedPrivateLinkResourceInner>
        beginCreateOrUpdateAsync(
            String resourceGroupName,
            String searchServiceName,
            String sharedPrivateLinkResourceName,
            UUID clientRequestId,
            SharedPrivateLinkResourceProperties properties,
            Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createOrUpdateWithResponseAsync(
                resourceGroupName,
                searchServiceName,
                sharedPrivateLinkResourceName,
                clientRequestId,
                properties,
                context);
        return this
            .client
            .<SharedPrivateLinkResourceInner, SharedPrivateLinkResourceInner>getLroResult(
                mono,
                this.client.getHttpPipeline(),
                SharedPrivateLinkResourceInner.class,
                SharedPrivateLinkResourceInner.class,
                context);
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<SharedPrivateLinkResourceInner>, SharedPrivateLinkResourceInner> beginCreateOrUpdate(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        SharedPrivateLinkResourceProperties properties) {
        return beginCreateOrUpdateAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties)
            .getSyncPoller();
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<SharedPrivateLinkResourceInner>, SharedPrivateLinkResourceInner> beginCreateOrUpdate(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        SharedPrivateLinkResourceProperties properties,
        Context context) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                searchServiceName,
                sharedPrivateLinkResourceName,
                clientRequestId,
                properties,
                context)
            .getSyncPoller();
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SharedPrivateLinkResourceInner> createOrUpdateAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        SharedPrivateLinkResourceProperties properties) {
        return beginCreateOrUpdateAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SharedPrivateLinkResourceInner> createOrUpdateAsync(
        String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        final UUID clientRequestId = null;
        final SharedPrivateLinkResourceProperties properties = null;
        return beginCreateOrUpdateAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<SharedPrivateLinkResourceInner> createOrUpdateAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        SharedPrivateLinkResourceProperties properties,
        Context context) {
        return beginCreateOrUpdateAsync(
                resourceGroupName,
                searchServiceName,
                sharedPrivateLinkResourceName,
                clientRequestId,
                properties,
                context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SharedPrivateLinkResourceInner createOrUpdate(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        SharedPrivateLinkResourceProperties properties) {
        return createOrUpdateAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties)
            .block();
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SharedPrivateLinkResourceInner createOrUpdate(
        String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        final UUID clientRequestId = null;
        final SharedPrivateLinkResourceProperties properties = null;
        return createOrUpdateAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, properties)
            .block();
    }

    /**
     * Initiates the creation or update of a shared private link resource managed by the search service in the given
     * resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param properties Describes the properties of an existing Shared Private Link Resource managed by the Azure
     *     Cognitive Search service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return describes a Shared Private Link Resource managed by the Azure Cognitive Search service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SharedPrivateLinkResourceInner createOrUpdate(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        SharedPrivateLinkResourceProperties properties,
        Context context) {
        return createOrUpdateAsync(
                resourceGroupName,
                searchServiceName,
                sharedPrivateLinkResourceName,
                clientRequestId,
                properties,
                context)
            .block();
    }

    /**
     * Gets the details of the shared private link resource managed by the search service in the given resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the shared private link resource managed by the search service in the given resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SharedPrivateLinkResourceInner>> getWithResponseAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            searchServiceName,
                            sharedPrivateLinkResourceName,
                            clientRequestId,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets the details of the shared private link resource managed by the search service in the given resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the shared private link resource managed by the search service in the given resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<SharedPrivateLinkResourceInner>> getWithResponseAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                searchServiceName,
                sharedPrivateLinkResourceName,
                clientRequestId,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Gets the details of the shared private link resource managed by the search service in the given resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the shared private link resource managed by the search service in the given resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SharedPrivateLinkResourceInner> getAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId) {
        return getWithResponseAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId)
            .flatMap(
                (Response<SharedPrivateLinkResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the details of the shared private link resource managed by the search service in the given resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the shared private link resource managed by the search service in the given resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SharedPrivateLinkResourceInner> getAsync(
        String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        final UUID clientRequestId = null;
        return getWithResponseAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId)
            .flatMap(
                (Response<SharedPrivateLinkResourceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets the details of the shared private link resource managed by the search service in the given resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the shared private link resource managed by the search service in the given resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SharedPrivateLinkResourceInner get(
        String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        final UUID clientRequestId = null;
        return getAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).block();
    }

    /**
     * Gets the details of the shared private link resource managed by the search service in the given resource group.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the details of the shared private link resource managed by the search service in the given resource
     *     group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<SharedPrivateLinkResourceInner> getWithResponse(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        Context context) {
        return getWithResponseAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context)
            .block();
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            searchServiceName,
                            sharedPrivateLinkResourceName,
                            clientRequestId,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        if (sharedPrivateLinkResourceName == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter sharedPrivateLinkResourceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                searchServiceName,
                sharedPrivateLinkResourceName,
                clientRequestId,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                accept,
                context);
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId);
        return this
            .client
            .<Void, Void>getLroResult(
                mono, this.client.getHttpPipeline(), Void.class, Void.class, this.client.getContext());
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId) {
        return beginDeleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId)
            .getSyncPoller();
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        Context context) {
        return beginDeleteAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context)
            .getSyncPoller();
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId) {
        return beginDeleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(
        String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        final UUID clientRequestId = null;
        return beginDeleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        Context context) {
        return beginDeleteAsync(
                resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId) {
        deleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).block();
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String searchServiceName, String sharedPrivateLinkResourceName) {
        final UUID clientRequestId = null;
        deleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId).block();
    }

    /**
     * Initiates the deletion of the shared private link resource from the search service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param sharedPrivateLinkResourceName The name of the shared private link resource managed by the Azure Cognitive
     *     Search service within the specified resource group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(
        String resourceGroupName,
        String searchServiceName,
        String sharedPrivateLinkResourceName,
        UUID clientRequestId,
        Context context) {
        deleteAsync(resourceGroupName, searchServiceName, sharedPrivateLinkResourceName, clientRequestId, context)
            .block();
    }

    /**
     * Gets a list of all shared private link resources managed by the given service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all shared private link resources managed by the given service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SharedPrivateLinkResourceInner>> listByServiceSinglePageAsync(
        String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByService(
                            this.client.getEndpoint(),
                            clientRequestId,
                            this.client.getApiVersion(),
                            this.client.getSubscriptionId(),
                            resourceGroupName,
                            searchServiceName,
                            accept,
                            context))
            .<PagedResponse<SharedPrivateLinkResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets a list of all shared private link resources managed by the given service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all shared private link resources managed by the given service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SharedPrivateLinkResourceInner>> listByServiceSinglePageAsync(
        String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (searchServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter searchServiceName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByService(
                this.client.getEndpoint(),
                clientRequestId,
                this.client.getApiVersion(),
                this.client.getSubscriptionId(),
                resourceGroupName,
                searchServiceName,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets a list of all shared private link resources managed by the given service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all shared private link resources managed by the given service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SharedPrivateLinkResourceInner> listByServiceAsync(
        String resourceGroupName, String searchServiceName, UUID clientRequestId) {
        return new PagedFlux<>(
            () -> listByServiceSinglePageAsync(resourceGroupName, searchServiceName, clientRequestId),
            nextLink -> listByServiceNextSinglePageAsync(nextLink, clientRequestId));
    }

    /**
     * Gets a list of all shared private link resources managed by the given service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all shared private link resources managed by the given service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<SharedPrivateLinkResourceInner> listByServiceAsync(
        String resourceGroupName, String searchServiceName) {
        final UUID clientRequestId = null;
        return new PagedFlux<>(
            () -> listByServiceSinglePageAsync(resourceGroupName, searchServiceName, clientRequestId),
            nextLink -> listByServiceNextSinglePageAsync(nextLink, clientRequestId));
    }

    /**
     * Gets a list of all shared private link resources managed by the given service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all shared private link resources managed by the given service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<SharedPrivateLinkResourceInner> listByServiceAsync(
        String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return new PagedFlux<>(
            () -> listByServiceSinglePageAsync(resourceGroupName, searchServiceName, clientRequestId, context),
            nextLink -> listByServiceNextSinglePageAsync(nextLink, clientRequestId, context));
    }

    /**
     * Gets a list of all shared private link resources managed by the given service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all shared private link resources managed by the given service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SharedPrivateLinkResourceInner> listByService(
        String resourceGroupName, String searchServiceName) {
        final UUID clientRequestId = null;
        return new PagedIterable<>(listByServiceAsync(resourceGroupName, searchServiceName, clientRequestId));
    }

    /**
     * Gets a list of all shared private link resources managed by the given service.
     *
     * @param resourceGroupName The name of the resource group within the current subscription. You can obtain this
     *     value from the Azure Resource Manager API or the portal.
     * @param searchServiceName The name of the Azure Cognitive Search service associated with the specified resource
     *     group.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all shared private link resources managed by the given service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<SharedPrivateLinkResourceInner> listByService(
        String resourceGroupName, String searchServiceName, UUID clientRequestId, Context context) {
        return new PagedIterable<>(listByServiceAsync(resourceGroupName, searchServiceName, clientRequestId, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing a list of Shared Private Link Resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SharedPrivateLinkResourceInner>> listByServiceNextSinglePageAsync(
        String nextLink, UUID clientRequestId) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service.listByServiceNext(nextLink, this.client.getEndpoint(), clientRequestId, accept, context))
            .<PagedResponse<SharedPrivateLinkResourceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param clientRequestId A client-generated GUID value that identifies this request. If specified, this will be
     *     included in response information as a way to track the request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response containing a list of Shared Private Link Resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<SharedPrivateLinkResourceInner>> listByServiceNextSinglePageAsync(
        String nextLink, UUID clientRequestId, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByServiceNext(nextLink, this.client.getEndpoint(), clientRequestId, accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
