// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The provider registration definition.
 */
@Fluent
public final class ProviderRegistrationRequest implements JsonSerializable<ProviderRegistrationRequest> {
    /*
     * The provider consent.
     */
    private ProviderConsentDefinition thirdPartyProviderConsent;

    /**
     * Creates an instance of ProviderRegistrationRequest class.
     */
    public ProviderRegistrationRequest() {
    }

    /**
     * Get the thirdPartyProviderConsent property: The provider consent.
     * 
     * @return the thirdPartyProviderConsent value.
     */
    public ProviderConsentDefinition thirdPartyProviderConsent() {
        return this.thirdPartyProviderConsent;
    }

    /**
     * Set the thirdPartyProviderConsent property: The provider consent.
     * 
     * @param thirdPartyProviderConsent the thirdPartyProviderConsent value to set.
     * @return the ProviderRegistrationRequest object itself.
     */
    public ProviderRegistrationRequest
        withThirdPartyProviderConsent(ProviderConsentDefinition thirdPartyProviderConsent) {
        this.thirdPartyProviderConsent = thirdPartyProviderConsent;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (thirdPartyProviderConsent() != null) {
            thirdPartyProviderConsent().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("thirdPartyProviderConsent", this.thirdPartyProviderConsent);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProviderRegistrationRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProviderRegistrationRequest if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProviderRegistrationRequest.
     */
    public static ProviderRegistrationRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProviderRegistrationRequest deserializedProviderRegistrationRequest = new ProviderRegistrationRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("thirdPartyProviderConsent".equals(fieldName)) {
                    deserializedProviderRegistrationRequest.thirdPartyProviderConsent
                        = ProviderConsentDefinition.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProviderRegistrationRequest;
        });
    }
}
