// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.resources.fluent.PolicySetDefinitionVersionsClient;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionVersionInner;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionVersionListResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in PolicySetDefinitionVersionsClient.
 */
public final class PolicySetDefinitionVersionsClientImpl
    implements InnerSupportsDelete<Void>, PolicySetDefinitionVersionsClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final PolicySetDefinitionVersionsService service;

    /**
     * The service client containing this operation class.
     */
    private final PolicyClientImpl client;

    /**
     * Initializes an instance of PolicySetDefinitionVersionsClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    PolicySetDefinitionVersionsClientImpl(PolicyClientImpl client) {
        this.service = RestProxy.create(PolicySetDefinitionVersionsService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for PolicyClientPolicySetDefinitionVersions to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "PolicyClientPolicySe")
    public interface PolicySetDefinitionVersionsService {
        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Authorization/listPolicySetDefinitionVersions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionListResultInner>> listAllBuiltins(@HostParam("$host") String endpoint,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/listPolicySetDefinitionVersions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionListResultInner>> listAllAtManagementGroup(
            @HostParam("$host") String endpoint, @PathParam("managementGroupName") String managementGroupName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Post("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/listPolicySetDefinitionVersions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionListResultInner>> listAll(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId, @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionInner>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @PathParam("policyDefinitionVersion") String policyDefinitionVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PolicySetDefinitionVersionInner parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @PathParam("policyDefinitionVersion") String policyDefinitionVersion,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @PathParam("policyDefinitionVersion") String policyDefinitionVersion, @QueryParam("$expand") String expand,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionInner>> getBuiltIn(@HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @PathParam("policyDefinitionVersion") String policyDefinitionVersion, @QueryParam("$expand") String expand,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionListResultInner>> list(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion, @QueryParam("$expand") String expand,
            @QueryParam("$top") Integer top, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionListResultInner>> listBuiltIn(@HostParam("$host") String endpoint,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion, @QueryParam("$expand") String expand,
            @QueryParam("$top") Integer top, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Put("/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionInner>> createOrUpdateAtManagementGroup(
            @HostParam("$host") String endpoint, @PathParam("managementGroupName") String managementGroupName,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @PathParam("policyDefinitionVersion") String policyDefinitionVersion,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PolicySetDefinitionVersionInner parameters,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses({ 200, 204 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Void>> deleteAtManagementGroup(@HostParam("$host") String endpoint,
            @PathParam("managementGroupName") String managementGroupName,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @PathParam("policyDefinitionVersion") String policyDefinitionVersion,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionInner>> getAtManagementGroup(@HostParam("$host") String endpoint,
            @PathParam("managementGroupName") String managementGroupName,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @PathParam("policyDefinitionVersion") String policyDefinitionVersion, @QueryParam("$expand") String expand,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionListResultInner>> listByManagementGroup(
            @HostParam("$host") String endpoint, @PathParam("managementGroupName") String managementGroupName,
            @PathParam("policySetDefinitionName") String policySetDefinitionName,
            @QueryParam("api-version") String apiVersion, @QueryParam("$expand") String expand,
            @QueryParam("$top") Integer top, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionListResultInner>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionListResultInner>> listBuiltInNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<PolicySetDefinitionVersionListResultInner>> listByManagementGroupNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Lists all built-in policy set definition versions.
     * 
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionVersionListResultInner>> listAllBuiltinsWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAllBuiltins(this.client.getEndpoint(), apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all built-in policy set definition versions.
     * 
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionVersionListResultInner>>
        listAllBuiltinsWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAllBuiltins(this.client.getEndpoint(), apiVersion, accept, context);
    }

    /**
     * Lists all built-in policy set definition versions.
     * 
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionVersionListResultInner> listAllBuiltinsAsync() {
        return listAllBuiltinsWithResponseAsync().flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists all built-in policy set definition versions.
     * 
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionVersionListResultInner> listAllBuiltinsWithResponse(Context context) {
        return listAllBuiltinsWithResponseAsync(context).block();
    }

    /**
     * Lists all built-in policy set definition versions.
     * 
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionVersionListResultInner listAllBuiltins() {
        return listAllBuiltinsWithResponse(Context.NONE).getValue();
    }

    /**
     * Lists all policy set definition versions at management group scope.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions at the management
     * group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionVersionListResultInner>>
        listAllAtManagementGroupWithResponseAsync(String managementGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAllAtManagementGroup(this.client.getEndpoint(), managementGroupName,
                apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all policy set definition versions at management group scope.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions at the management
     * group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionVersionListResultInner>>
        listAllAtManagementGroupWithResponseAsync(String managementGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAllAtManagementGroup(this.client.getEndpoint(), managementGroupName, apiVersion, accept,
            context);
    }

    /**
     * Lists all policy set definition versions at management group scope.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions at the management
     * group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionVersionListResultInner> listAllAtManagementGroupAsync(String managementGroupName) {
        return listAllAtManagementGroupWithResponseAsync(managementGroupName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists all policy set definition versions at management group scope.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions at the management
     * group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionVersionListResultInner>
        listAllAtManagementGroupWithResponse(String managementGroupName, Context context) {
        return listAllAtManagementGroupWithResponseAsync(managementGroupName, context).block();
    }

    /**
     * Lists all policy set definition versions at management group scope.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions at the management
     * group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionVersionListResultInner listAllAtManagementGroup(String managementGroupName) {
        return listAllAtManagementGroupWithResponse(managementGroupName, Context.NONE).getValue();
    }

    /**
     * Lists all policy set definition versions within a subscription.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionVersionListResultInner>> listAllWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listAll(this.client.getEndpoint(), this.client.getSubscriptionId(),
                apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Lists all policy set definition versions within a subscription.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionVersionListResultInner>> listAllWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listAll(this.client.getEndpoint(), this.client.getSubscriptionId(), apiVersion, accept, context);
    }

    /**
     * Lists all policy set definition versions within a subscription.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionVersionListResultInner> listAllAsync() {
        return listAllWithResponseAsync().flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Lists all policy set definition versions within a subscription.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionVersionListResultInner> listAllWithResponse(Context context) {
        return listAllWithResponseAsync(context).block();
    }

    /**
     * Lists all policy set definition versions within a subscription.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * 
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionVersionListResultInner listAll() {
        return listAllWithResponse(Context.NONE).getValue();
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given subscription with the given name
     * and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionVersionInner>> createOrUpdateWithResponseAsync(
        String policySetDefinitionName, String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                policySetDefinitionName, policyDefinitionVersion, apiVersion, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given subscription with the given name
     * and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionVersionInner>> createOrUpdateWithResponseAsync(
        String policySetDefinitionName, String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
            policySetDefinitionName, policyDefinitionVersion, apiVersion, parameters, accept, context);
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given subscription with the given name
     * and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionVersionInner> createOrUpdateAsync(String policySetDefinitionName,
        String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters) {
        return createOrUpdateWithResponseAsync(policySetDefinitionName, policyDefinitionVersion, parameters)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given subscription with the given name
     * and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionVersionInner> createOrUpdateWithResponse(String policySetDefinitionName,
        String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters, Context context) {
        return createOrUpdateWithResponseAsync(policySetDefinitionName, policyDefinitionVersion, parameters, context)
            .block();
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given subscription with the given name
     * and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionVersionInner createOrUpdate(String policySetDefinitionName,
        String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters) {
        return createOrUpdateWithResponse(policySetDefinitionName, policyDefinitionVersion, parameters, Context.NONE)
            .getValue();
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName,
        String policyDefinitionVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                policySetDefinitionName, policyDefinitionVersion, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName, String policyDefinitionVersion,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), policySetDefinitionName,
            policyDefinitionVersion, apiVersion, accept, context);
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String policySetDefinitionName, String policyDefinitionVersion) {
        return deleteWithResponseAsync(policySetDefinitionName, policyDefinitionVersion)
            .flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String policySetDefinitionName, String policyDefinitionVersion,
        Context context) {
        return deleteWithResponseAsync(policySetDefinitionName, policyDefinitionVersion, context).block();
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String policySetDefinitionName, String policyDefinitionVersion) {
        deleteWithResponse(policySetDefinitionName, policyDefinitionVersion, Context.NONE);
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionVersionInner>> getWithResponseAsync(String policySetDefinitionName,
        String policyDefinitionVersion, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                policySetDefinitionName, policyDefinitionVersion, expand, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionVersionInner>> getWithResponseAsync(String policySetDefinitionName,
        String policyDefinitionVersion, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), policySetDefinitionName,
            policyDefinitionVersion, expand, apiVersion, accept, context);
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionVersionInner> getAsync(String policySetDefinitionName,
        String policyDefinitionVersion) {
        final String expand = null;
        return getWithResponseAsync(policySetDefinitionName, policyDefinitionVersion, expand)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionVersionInner> getWithResponse(String policySetDefinitionName,
        String policyDefinitionVersion, String expand, Context context) {
        return getWithResponseAsync(policySetDefinitionName, policyDefinitionVersion, expand, context).block();
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionVersionInner get(String policySetDefinitionName, String policyDefinitionVersion) {
        final String expand = null;
        return getWithResponse(policySetDefinitionName, policyDefinitionVersion, expand, Context.NONE).getValue();
    }

    /**
     * Retrieves a built in policy set definition version.
     * 
     * This operation retrieves the built-in policy set definition version with the given name and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionVersionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName,
        String policyDefinitionVersion, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getBuiltIn(this.client.getEndpoint(), policySetDefinitionName,
                policyDefinitionVersion, expand, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves a built in policy set definition version.
     * 
     * This operation retrieves the built-in policy set definition version with the given name and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionVersionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName,
        String policyDefinitionVersion, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getBuiltIn(this.client.getEndpoint(), policySetDefinitionName, policyDefinitionVersion, expand,
            apiVersion, accept, context);
    }

    /**
     * Retrieves a built in policy set definition version.
     * 
     * This operation retrieves the built-in policy set definition version with the given name and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionVersionInner> getBuiltInAsync(String policySetDefinitionName,
        String policyDefinitionVersion) {
        final String expand = null;
        return getBuiltInWithResponseAsync(policySetDefinitionName, policyDefinitionVersion, expand)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a built in policy set definition version.
     * 
     * This operation retrieves the built-in policy set definition version with the given name and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionVersionInner> getBuiltInWithResponse(String policySetDefinitionName,
        String policyDefinitionVersion, String expand, Context context) {
        return getBuiltInWithResponseAsync(policySetDefinitionName, policyDefinitionVersion, expand, context).block();
    }

    /**
     * Retrieves a built in policy set definition version.
     * 
     * This operation retrieves the built-in policy set definition version with the given name and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionVersionInner getBuiltIn(String policySetDefinitionName, String policyDefinitionVersion) {
        final String expand = null;
        return getBuiltInWithResponse(policySetDefinitionName, policyDefinitionVersion, expand, Context.NONE)
            .getValue();
    }

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>> listSinglePageAsync(String policySetDefinitionName,
        String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.list(this.client.getEndpoint(), this.client.getSubscriptionId(),
                policySetDefinitionName, apiVersion, expand, top, accept, context))
            .<PagedResponse<PolicySetDefinitionVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>> listSinglePageAsync(String policySetDefinitionName,
        String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(this.client.getEndpoint(), this.client.getSubscriptionId(), policySetDefinitionName, apiVersion,
                expand, top, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionVersionInner> listAsync(String policySetDefinitionName, String expand,
        Integer top) {
        return new PagedFlux<>(() -> listSinglePageAsync(policySetDefinitionName, expand, top),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionVersionInner> listAsync(String policySetDefinitionName) {
        final String expand = null;
        final Integer top = null;
        return new PagedFlux<>(() -> listSinglePageAsync(policySetDefinitionName, expand, top),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionVersionInner> listAsync(String policySetDefinitionName, String expand,
        Integer top, Context context) {
        return new PagedFlux<>(() -> listSinglePageAsync(policySetDefinitionName, expand, top, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionVersionInner> list(String policySetDefinitionName) {
        final String expand = null;
        final Integer top = null;
        return new PagedIterable<>(listAsync(policySetDefinitionName, expand, top));
    }

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionVersionInner> list(String policySetDefinitionName, String expand,
        Integer top, Context context) {
        return new PagedIterable<>(listAsync(policySetDefinitionName, expand, top, context));
    }

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>>
        listBuiltInSinglePageAsync(String policySetDefinitionName, String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBuiltIn(this.client.getEndpoint(), policySetDefinitionName, apiVersion,
                expand, top, accept, context))
            .<PagedResponse<PolicySetDefinitionVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>>
        listBuiltInSinglePageAsync(String policySetDefinitionName, String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listBuiltIn(this.client.getEndpoint(), policySetDefinitionName, apiVersion, expand, top, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionVersionInner> listBuiltInAsync(String policySetDefinitionName, String expand,
        Integer top) {
        return new PagedFlux<>(() -> listBuiltInSinglePageAsync(policySetDefinitionName, expand, top),
            nextLink -> listBuiltInNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionVersionInner> listBuiltInAsync(String policySetDefinitionName) {
        final String expand = null;
        final Integer top = null;
        return new PagedFlux<>(() -> listBuiltInSinglePageAsync(policySetDefinitionName, expand, top),
            nextLink -> listBuiltInNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionVersionInner> listBuiltInAsync(String policySetDefinitionName, String expand,
        Integer top, Context context) {
        return new PagedFlux<>(() -> listBuiltInSinglePageAsync(policySetDefinitionName, expand, top, context),
            nextLink -> listBuiltInNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionVersionInner> listBuiltIn(String policySetDefinitionName) {
        final String expand = null;
        final Integer top = null;
        return new PagedIterable<>(listBuiltInAsync(policySetDefinitionName, expand, top));
    }

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionVersionInner> listBuiltIn(String policySetDefinitionName, String expand,
        Integer top, Context context) {
        return new PagedIterable<>(listBuiltInAsync(policySetDefinitionName, expand, top, context));
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given management group with the given
     * name and version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition version properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionVersionInner>> createOrUpdateAtManagementGroupWithResponseAsync(
        String managementGroupName, String policySetDefinitionName, String policyDefinitionVersion,
        PolicySetDefinitionVersionInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), managementGroupName,
                    policySetDefinitionName, policyDefinitionVersion, apiVersion, parameters, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given management group with the given
     * name and version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition version properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionVersionInner>> createOrUpdateAtManagementGroupWithResponseAsync(
        String managementGroupName, String policySetDefinitionName, String policyDefinitionVersion,
        PolicySetDefinitionVersionInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        } else {
            parameters.validate();
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdateAtManagementGroup(this.client.getEndpoint(), managementGroupName,
            policySetDefinitionName, policyDefinitionVersion, apiVersion, parameters, accept, context);
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given management group with the given
     * name and version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition version properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionVersionInner> createOrUpdateAtManagementGroupAsync(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters) {
        return createOrUpdateAtManagementGroupWithResponseAsync(managementGroupName, policySetDefinitionName,
            policyDefinitionVersion, parameters).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given management group with the given
     * name and version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition version properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionVersionInner> createOrUpdateAtManagementGroupWithResponse(
        String managementGroupName, String policySetDefinitionName, String policyDefinitionVersion,
        PolicySetDefinitionVersionInner parameters, Context context) {
        return createOrUpdateAtManagementGroupWithResponseAsync(managementGroupName, policySetDefinitionName,
            policyDefinitionVersion, parameters, context).block();
    }

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given management group with the given
     * name and version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition version properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionVersionInner createOrUpdateAtManagementGroup(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters) {
        return createOrUpdateAtManagementGroupWithResponse(managementGroupName, policySetDefinitionName,
            policyDefinitionVersion, parameters, Context.NONE).getValue();
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.deleteAtManagementGroup(this.client.getEndpoint(), managementGroupName,
                policySetDefinitionName, policyDefinitionVersion, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.deleteAtManagementGroup(this.client.getEndpoint(), managementGroupName, policySetDefinitionName,
            policyDefinitionVersion, apiVersion, accept, context);
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAtManagementGroupAsync(String managementGroupName, String policySetDefinitionName,
        String policyDefinitionVersion) {
        return deleteAtManagementGroupWithResponseAsync(managementGroupName, policySetDefinitionName,
            policyDefinitionVersion).flatMap(ignored -> Mono.empty());
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<Void> deleteAtManagementGroupWithResponse(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, Context context) {
        return deleteAtManagementGroupWithResponseAsync(managementGroupName, policySetDefinitionName,
            policyDefinitionVersion, context).block();
    }

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void deleteAtManagementGroup(String managementGroupName, String policySetDefinitionName,
        String policyDefinitionVersion) {
        deleteAtManagementGroupWithResponse(managementGroupName, policySetDefinitionName, policyDefinitionVersion,
            Context.NONE);
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<PolicySetDefinitionVersionInner>> getAtManagementGroupWithResponseAsync(
        String managementGroupName, String policySetDefinitionName, String policyDefinitionVersion, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.getAtManagementGroup(this.client.getEndpoint(), managementGroupName,
                policySetDefinitionName, policyDefinitionVersion, expand, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<PolicySetDefinitionVersionInner>> getAtManagementGroupWithResponseAsync(
        String managementGroupName, String policySetDefinitionName, String policyDefinitionVersion, String expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        if (policyDefinitionVersion == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policyDefinitionVersion is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.getAtManagementGroup(this.client.getEndpoint(), managementGroupName, policySetDefinitionName,
            policyDefinitionVersion, expand, apiVersion, accept, context);
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<PolicySetDefinitionVersionInner> getAtManagementGroupAsync(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion) {
        final String expand = null;
        return getAtManagementGroupWithResponseAsync(managementGroupName, policySetDefinitionName,
            policyDefinitionVersion, expand).flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<PolicySetDefinitionVersionInner> getAtManagementGroupWithResponse(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, String expand, Context context) {
        return getAtManagementGroupWithResponseAsync(managementGroupName, policySetDefinitionName,
            policyDefinitionVersion, expand, context).block();
    }

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PolicySetDefinitionVersionInner getAtManagementGroup(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion) {
        final String expand = null;
        return getAtManagementGroupWithResponse(managementGroupName, policySetDefinitionName, policyDefinitionVersion,
            expand, Context.NONE).getValue();
    }

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>> listByManagementGroupSinglePageAsync(
        String managementGroupName, String policySetDefinitionName, String expand, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByManagementGroup(this.client.getEndpoint(), managementGroupName,
                policySetDefinitionName, apiVersion, expand, top, accept, context))
            .<PagedResponse<PolicySetDefinitionVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>> listByManagementGroupSinglePageAsync(
        String managementGroupName, String policySetDefinitionName, String expand, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (managementGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter managementGroupName is required and cannot be null."));
        }
        if (policySetDefinitionName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter policySetDefinitionName is required and cannot be null."));
        }
        final String apiVersion = "2023-04-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByManagementGroup(this.client.getEndpoint(), managementGroupName, policySetDefinitionName, apiVersion,
                expand, top, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName,
        String policySetDefinitionName, String expand, Integer top) {
        return new PagedFlux<>(
            () -> listByManagementGroupSinglePageAsync(managementGroupName, policySetDefinitionName, expand, top),
            nextLink -> listByManagementGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<PolicySetDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName,
        String policySetDefinitionName) {
        final String expand = null;
        final Integer top = null;
        return new PagedFlux<>(
            () -> listByManagementGroupSinglePageAsync(managementGroupName, policySetDefinitionName, expand, top),
            nextLink -> listByManagementGroupNextSinglePageAsync(nextLink));
    }

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<PolicySetDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName,
        String policySetDefinitionName, String expand, Integer top, Context context) {
        return new PagedFlux<>(() -> listByManagementGroupSinglePageAsync(managementGroupName, policySetDefinitionName,
            expand, top, context), nextLink -> listByManagementGroupNextSinglePageAsync(nextLink, context));
    }

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionVersionInner> listByManagementGroup(String managementGroupName,
        String policySetDefinitionName) {
        final String expand = null;
        final Integer top = null;
        return new PagedIterable<>(
            listByManagementGroupAsync(managementGroupName, policySetDefinitionName, expand, top));
    }

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<PolicySetDefinitionVersionInner> listByManagementGroup(String managementGroupName,
        String policySetDefinitionName, String expand, Integer top, Context context) {
        return new PagedIterable<>(
            listByManagementGroupAsync(managementGroupName, policySetDefinitionName, expand, top, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil.withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicySetDefinitionVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>> listNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>> listBuiltInNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listBuiltInNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicySetDefinitionVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>> listBuiltInNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listBuiltInNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>>
        listByManagementGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context -> service.listByManagementGroupNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<PolicySetDefinitionVersionInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link PagedResponse} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<PolicySetDefinitionVersionInner>>
        listByManagementGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByManagementGroupNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
