// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ProviderAuthorizationConsentState;
import com.azure.resourcemanager.resources.models.ProviderResourceType;
import java.io.IOException;
import java.util.List;

/**
 * Resource provider information.
 */
@Fluent
public final class ProviderInner implements JsonSerializable<ProviderInner> {
    /*
     * The provider ID.
     */
    private String id;

    /*
     * The namespace of the resource provider.
     */
    private String namespace;

    /*
     * The registration state of the resource provider.
     */
    private String registrationState;

    /*
     * The registration policy of the resource provider.
     */
    private String registrationPolicy;

    /*
     * The collection of provider resource types.
     */
    private List<ProviderResourceType> resourceTypes;

    /*
     * The provider authorization consent state.
     */
    private ProviderAuthorizationConsentState providerAuthorizationConsentState;

    /**
     * Creates an instance of ProviderInner class.
     */
    public ProviderInner() {
    }

    /**
     * Get the id property: The provider ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the namespace property: The namespace of the resource provider.
     * 
     * @return the namespace value.
     */
    public String namespace() {
        return this.namespace;
    }

    /**
     * Set the namespace property: The namespace of the resource provider.
     * 
     * @param namespace the namespace value to set.
     * @return the ProviderInner object itself.
     */
    public ProviderInner withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    /**
     * Get the registrationState property: The registration state of the resource provider.
     * 
     * @return the registrationState value.
     */
    public String registrationState() {
        return this.registrationState;
    }

    /**
     * Get the registrationPolicy property: The registration policy of the resource provider.
     * 
     * @return the registrationPolicy value.
     */
    public String registrationPolicy() {
        return this.registrationPolicy;
    }

    /**
     * Get the resourceTypes property: The collection of provider resource types.
     * 
     * @return the resourceTypes value.
     */
    public List<ProviderResourceType> resourceTypes() {
        return this.resourceTypes;
    }

    /**
     * Get the providerAuthorizationConsentState property: The provider authorization consent state.
     * 
     * @return the providerAuthorizationConsentState value.
     */
    public ProviderAuthorizationConsentState providerAuthorizationConsentState() {
        return this.providerAuthorizationConsentState;
    }

    /**
     * Set the providerAuthorizationConsentState property: The provider authorization consent state.
     * 
     * @param providerAuthorizationConsentState the providerAuthorizationConsentState value to set.
     * @return the ProviderInner object itself.
     */
    public ProviderInner
        withProviderAuthorizationConsentState(ProviderAuthorizationConsentState providerAuthorizationConsentState) {
        this.providerAuthorizationConsentState = providerAuthorizationConsentState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceTypes() != null) {
            resourceTypes().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeStringField("providerAuthorizationConsentState",
            this.providerAuthorizationConsentState == null ? null : this.providerAuthorizationConsentState.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProviderInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProviderInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProviderInner.
     */
    public static ProviderInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProviderInner deserializedProviderInner = new ProviderInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedProviderInner.id = reader.getString();
                } else if ("namespace".equals(fieldName)) {
                    deserializedProviderInner.namespace = reader.getString();
                } else if ("registrationState".equals(fieldName)) {
                    deserializedProviderInner.registrationState = reader.getString();
                } else if ("registrationPolicy".equals(fieldName)) {
                    deserializedProviderInner.registrationPolicy = reader.getString();
                } else if ("resourceTypes".equals(fieldName)) {
                    List<ProviderResourceType> resourceTypes
                        = reader.readArray(reader1 -> ProviderResourceType.fromJson(reader1));
                    deserializedProviderInner.resourceTypes = resourceTypes;
                } else if ("providerAuthorizationConsentState".equals(fieldName)) {
                    deserializedProviderInner.providerAuthorizationConsentState
                        = ProviderAuthorizationConsentState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProviderInner;
        });
    }
}
