// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionVersionInner;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionVersionListResultInner;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in PolicySetDefinitionVersionsClient.
 */
public interface PolicySetDefinitionVersionsClient extends InnerSupportsDelete<Void> {
    /**
     * Lists all built-in policy set definition versions.
     * 
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionVersionListResultInner>> listAllBuiltinsWithResponseAsync();

    /**
     * Lists all built-in policy set definition versions.
     * 
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionVersionListResultInner> listAllBuiltinsAsync();

    /**
     * Lists all built-in policy set definition versions.
     * 
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionVersionListResultInner> listAllBuiltinsWithResponse(Context context);

    /**
     * Lists all built-in policy set definition versions.
     * 
     * This operation lists all the built-in policy set definition versions for all built-in policy set definitions.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionVersionListResultInner listAllBuiltins();

    /**
     * Lists all policy set definition versions at management group scope.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions at the management
     * group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionVersionListResultInner>>
        listAllAtManagementGroupWithResponseAsync(String managementGroupName);

    /**
     * Lists all policy set definition versions at management group scope.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions at the management
     * group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionVersionListResultInner> listAllAtManagementGroupAsync(String managementGroupName);

    /**
     * Lists all policy set definition versions at management group scope.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions at the management
     * group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionVersionListResultInner> listAllAtManagementGroupWithResponse(String managementGroupName,
        Context context);

    /**
     * Lists all policy set definition versions at management group scope.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions at the management
     * group scope.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionVersionListResultInner listAllAtManagementGroup(String managementGroupName);

    /**
     * Lists all policy set definition versions within a subscription.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionVersionListResultInner>> listAllWithResponseAsync();

    /**
     * Lists all policy set definition versions within a subscription.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionVersionListResultInner> listAllAsync();

    /**
     * Lists all policy set definition versions within a subscription.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionVersionListResultInner> listAllWithResponse(Context context);

    /**
     * Lists all policy set definition versions within a subscription.
     * 
     * This operation lists all the policy set definition versions for all policy set definitions within a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionVersionListResultInner listAll();

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given subscription with the given name
     * and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionVersionInner>> createOrUpdateWithResponseAsync(String policySetDefinitionName,
        String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters);

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given subscription with the given name
     * and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionVersionInner> createOrUpdateAsync(String policySetDefinitionName,
        String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters);

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given subscription with the given name
     * and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionVersionInner> createOrUpdateWithResponse(String policySetDefinitionName,
        String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters, Context context);

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given subscription with the given name
     * and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionVersionInner createOrUpdate(String policySetDefinitionName, String policyDefinitionVersion,
        PolicySetDefinitionVersionInner parameters);

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String policySetDefinitionName, String policyDefinitionVersion);

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String policySetDefinitionName, String policyDefinitionVersion);

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String policySetDefinitionName, String policyDefinitionVersion, Context context);

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String policySetDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionVersionInner>> getWithResponseAsync(String policySetDefinitionName,
        String policyDefinitionVersion, String expand);

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionVersionInner> getAsync(String policySetDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionVersionInner> getWithResponse(String policySetDefinitionName,
        String policyDefinitionVersion, String expand, Context context);

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given subscription with the given name and
     * version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionVersionInner get(String policySetDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieves a built in policy set definition version.
     * 
     * This operation retrieves the built-in policy set definition version with the given name and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionVersionInner>> getBuiltInWithResponseAsync(String policySetDefinitionName,
        String policyDefinitionVersion, String expand);

    /**
     * Retrieves a built in policy set definition version.
     * 
     * This operation retrieves the built-in policy set definition version with the given name and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionVersionInner> getBuiltInAsync(String policySetDefinitionName,
        String policyDefinitionVersion);

    /**
     * Retrieves a built in policy set definition version.
     * 
     * This operation retrieves the built-in policy set definition version with the given name and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionVersionInner> getBuiltInWithResponse(String policySetDefinitionName,
        String policyDefinitionVersion, String expand, Context context);

    /**
     * Retrieves a built in policy set definition version.
     * 
     * This operation retrieves the built-in policy set definition version with the given name and version.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionVersionInner getBuiltIn(String policySetDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionVersionInner> listAsync(String policySetDefinitionName, String expand, Integer top);

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionVersionInner> listAsync(String policySetDefinitionName);

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionVersionInner> list(String policySetDefinitionName);

    /**
     * Retrieves the policy set definition versions for a given policy set definition in a subscription.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionVersionInner> list(String policySetDefinitionName, String expand, Integer top,
        Context context);

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionVersionInner> listBuiltInAsync(String policySetDefinitionName, String expand,
        Integer top);

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionVersionInner> listBuiltInAsync(String policySetDefinitionName);

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionVersionInner> listBuiltIn(String policySetDefinitionName);

    /**
     * Retrieves built-in policy set definition versions.
     * 
     * This operation retrieves a list of all the built-in policy set definition versions for the given built-in policy
     * set definition.
     * 
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionVersionInner> listBuiltIn(String policySetDefinitionName, String expand,
        Integer top, Context context);

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given management group with the given
     * name and version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition version properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionVersionInner>> createOrUpdateAtManagementGroupWithResponseAsync(
        String managementGroupName, String policySetDefinitionName, String policyDefinitionVersion,
        PolicySetDefinitionVersionInner parameters);

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given management group with the given
     * name and version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition version properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionVersionInner> createOrUpdateAtManagementGroupAsync(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters);

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given management group with the given
     * name and version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition version properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionVersionInner> createOrUpdateAtManagementGroupWithResponse(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters,
        Context context);

    /**
     * Creates or updates a policy set definition version.
     * 
     * This operation creates or updates a policy set definition version in the given management group with the given
     * name and version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param parameters The policy set definition version properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionVersionInner createOrUpdateAtManagementGroup(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, PolicySetDefinitionVersionInner parameters);

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteAtManagementGroupWithResponseAsync(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion);

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAtManagementGroupAsync(String managementGroupName, String policySetDefinitionName,
        String policyDefinitionVersion);

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteAtManagementGroupWithResponse(String managementGroupName, String policySetDefinitionName,
        String policyDefinitionVersion, Context context);

    /**
     * Deletes a policy set definition version.
     * 
     * This operation deletes the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteAtManagementGroup(String managementGroupName, String policySetDefinitionName,
        String policyDefinitionVersion);

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PolicySetDefinitionVersionInner>> getAtManagementGroupWithResponseAsync(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, String expand);

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PolicySetDefinitionVersionInner> getAtManagementGroupAsync(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion);

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PolicySetDefinitionVersionInner> getAtManagementGroupWithResponse(String managementGroupName,
        String policySetDefinitionName, String policyDefinitionVersion, String expand, Context context);

    /**
     * Retrieves a policy set definition version.
     * 
     * This operation retrieves the policy set definition version in the given management group with the given name and
     * version.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param policyDefinitionVersion The policy set definition version. The format is x.y.z where x is the major
     * version number, y is the minor version number, and z is the patch number.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the policy set definition version.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PolicySetDefinitionVersionInner getAtManagementGroup(String managementGroupName, String policySetDefinitionName,
        String policyDefinitionVersion);

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName,
        String policySetDefinitionName, String expand, Integer top);

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PolicySetDefinitionVersionInner> listByManagementGroupAsync(String managementGroupName,
        String policySetDefinitionName);

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionVersionInner> listByManagementGroup(String managementGroupName,
        String policySetDefinitionName);

    /**
     * Retrieves all policy set definition versions for a given policy set definition in a management group.
     * 
     * This operation retrieves a list of all the policy set definition versions for the given policy set definition in
     * a given management group.
     * 
     * @param managementGroupName The name of the management group. The name is case insensitive.
     * @param policySetDefinitionName The name of the policy set definition.
     * @param expand Comma-separated list of additional properties to be included in the response. Supported values are
     * 'LatestDefinitionVersion, EffectiveDefinitionVersion'.
     * @param top Maximum number of records to return. When the $top filter is not provided, it will return 500 records.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of policy set definition versions as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PolicySetDefinitionVersionInner> listByManagementGroup(String managementGroupName,
        String policySetDefinitionName, String expand, Integer top, Context context);
}
