// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The level of validation performed on the deployment.
 */
public final class ValidationLevel extends ExpandableStringEnum<ValidationLevel> {
    /**
     * Static value Template for ValidationLevel.
     */
    public static final ValidationLevel TEMPLATE = fromString("Template");

    /**
     * Static value Provider for ValidationLevel.
     */
    public static final ValidationLevel PROVIDER = fromString("Provider");

    /**
     * Static value ProviderNoRbac for ValidationLevel.
     */
    public static final ValidationLevel PROVIDER_NO_RBAC = fromString("ProviderNoRbac");

    /**
     * Creates a new instance of ValidationLevel value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ValidationLevel() {
    }

    /**
     * Creates or finds a ValidationLevel from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ValidationLevel.
     */
    public static ValidationLevel fromString(String name) {
        return fromString(name, ValidationLevel.class);
    }

    /**
     * Gets known ValidationLevel values.
     * 
     * @return known ValidationLevel values.
     */
    public static Collection<ValidationLevel> values() {
        return values(ValidationLevel.class);
    }
}
