// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information regarding paired region.
 */
@Immutable
public final class PairedRegion implements JsonSerializable<PairedRegion> {
    /*
     * The name of the paired region.
     */
    private String name;

    /*
     * The fully qualified ID of the location. For example,
     * /subscriptions/8d65815f-a5b6-402f-9298-045155da7d74/locations/westus.
     */
    private String id;

    /*
     * The subscription ID.
     */
    private String subscriptionId;

    /**
     * Creates an instance of PairedRegion class.
     */
    public PairedRegion() {
    }

    /**
     * Get the name property: The name of the paired region.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: The fully qualified ID of the location. For example,
     * /subscriptions/8d65815f-a5b6-402f-9298-045155da7d74/locations/westus.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the subscriptionId property: The subscription ID.
     * 
     * @return the subscriptionId value.
     */
    public String subscriptionId() {
        return this.subscriptionId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PairedRegion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PairedRegion if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the PairedRegion.
     */
    public static PairedRegion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PairedRegion deserializedPairedRegion = new PairedRegion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedPairedRegion.name = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedPairedRegion.id = reader.getString();
                } else if ("subscriptionId".equals(fieldName)) {
                    deserializedPairedRegion.subscriptionId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPairedRegion;
        });
    }
}
