// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Export resource group template request parameters.
 */
@Fluent
public final class ExportTemplateRequest implements JsonSerializable<ExportTemplateRequest> {
    /*
     * The IDs of the resources to filter the export by. To export all resources, supply an array with single entry '*'.
     */
    private List<String> resources;

    /*
     * The export template options. A CSV-formatted list containing zero or more of the following:
     * 'IncludeParameterDefaultValue', 'IncludeComments', 'SkipResourceNameParameterization', 'SkipAllParameterization'
     */
    private String options;

    /*
     * The output format for the exported resources.
     */
    private ExportTemplateOutputFormat outputFormat;

    /**
     * Creates an instance of ExportTemplateRequest class.
     */
    public ExportTemplateRequest() {
    }

    /**
     * Get the resources property: The IDs of the resources to filter the export by. To export all resources, supply an
     * array with single entry '*'.
     * 
     * @return the resources value.
     */
    public List<String> resources() {
        return this.resources;
    }

    /**
     * Set the resources property: The IDs of the resources to filter the export by. To export all resources, supply an
     * array with single entry '*'.
     * 
     * @param resources the resources value to set.
     * @return the ExportTemplateRequest object itself.
     */
    public ExportTemplateRequest withResources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    /**
     * Get the options property: The export template options. A CSV-formatted list containing zero or more of the
     * following: 'IncludeParameterDefaultValue', 'IncludeComments', 'SkipResourceNameParameterization',
     * 'SkipAllParameterization'.
     * 
     * @return the options value.
     */
    public String options() {
        return this.options;
    }

    /**
     * Set the options property: The export template options. A CSV-formatted list containing zero or more of the
     * following: 'IncludeParameterDefaultValue', 'IncludeComments', 'SkipResourceNameParameterization',
     * 'SkipAllParameterization'.
     * 
     * @param options the options value to set.
     * @return the ExportTemplateRequest object itself.
     */
    public ExportTemplateRequest withOptions(String options) {
        this.options = options;
        return this;
    }

    /**
     * Get the outputFormat property: The output format for the exported resources.
     * 
     * @return the outputFormat value.
     */
    public ExportTemplateOutputFormat outputFormat() {
        return this.outputFormat;
    }

    /**
     * Set the outputFormat property: The output format for the exported resources.
     * 
     * @param outputFormat the outputFormat value to set.
     * @return the ExportTemplateRequest object itself.
     */
    public ExportTemplateRequest withOutputFormat(ExportTemplateOutputFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("options", this.options);
        jsonWriter.writeStringField("outputFormat", this.outputFormat == null ? null : this.outputFormat.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExportTemplateRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExportTemplateRequest if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExportTemplateRequest.
     */
    public static ExportTemplateRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExportTemplateRequest deserializedExportTemplateRequest = new ExportTemplateRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resources".equals(fieldName)) {
                    List<String> resources = reader.readArray(reader1 -> reader1.getString());
                    deserializedExportTemplateRequest.resources = resources;
                } else if ("options".equals(fieldName)) {
                    deserializedExportTemplateRequest.options = reader.getString();
                } else if ("outputFormat".equals(fieldName)) {
                    deserializedExportTemplateRequest.outputFormat
                        = ExportTemplateOutputFormat.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExportTemplateRequest;
        });
    }
}
