// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Deployment external input definition for parameterization.
 */
@Fluent
public final class DeploymentExternalInputDefinition implements JsonSerializable<DeploymentExternalInputDefinition> {
    /*
     * The kind of external input.
     */
    private String kind;

    /*
     * Configuration for the external input.
     */
    private Object config;

    /**
     * Creates an instance of DeploymentExternalInputDefinition class.
     */
    public DeploymentExternalInputDefinition() {
    }

    /**
     * Get the kind property: The kind of external input.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The kind of external input.
     * 
     * @param kind the kind value to set.
     * @return the DeploymentExternalInputDefinition object itself.
     */
    public DeploymentExternalInputDefinition withKind(String kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the config property: Configuration for the external input.
     * 
     * @return the config value.
     */
    public Object config() {
        return this.config;
    }

    /**
     * Set the config property: Configuration for the external input.
     * 
     * @param config the config value to set.
     * @return the DeploymentExternalInputDefinition object itself.
     */
    public DeploymentExternalInputDefinition withConfig(Object config) {
        this.config = config;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (kind() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property kind in model DeploymentExternalInputDefinition"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DeploymentExternalInputDefinition.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind);
        if (this.config != null) {
            jsonWriter.writeUntypedField("config", this.config);
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentExternalInputDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentExternalInputDefinition if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DeploymentExternalInputDefinition.
     */
    public static DeploymentExternalInputDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentExternalInputDefinition deserializedDeploymentExternalInputDefinition
                = new DeploymentExternalInputDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedDeploymentExternalInputDefinition.kind = reader.getString();
                } else if ("config".equals(fieldName)) {
                    deserializedDeploymentExternalInputDefinition.config = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentExternalInputDefinition;
        });
    }
}
