// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.LockLevel;
import com.azure.resourcemanager.resources.models.ManagementLockOwner;
import java.io.IOException;
import java.util.List;

/**
 * The lock properties.
 */
@Fluent
public final class ManagementLockProperties implements JsonSerializable<ManagementLockProperties> {
    /*
     * The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized
     * users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read
     * from a resource, but they can't modify or delete it.
     */
    private LockLevel level;

    /*
     * Notes about the lock. Maximum of 512 characters.
     */
    private String notes;

    /*
     * The owners of the lock.
     */
    private List<ManagementLockOwner> owners;

    /**
     * Creates an instance of ManagementLockProperties class.
     */
    public ManagementLockProperties() {
    }

    /**
     * Get the level property: The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly.
     * CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means
     * authorized users can only read from a resource, but they can't modify or delete it.
     * 
     * @return the level value.
     */
    public LockLevel level() {
        return this.level;
    }

    /**
     * Set the level property: The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly.
     * CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means
     * authorized users can only read from a resource, but they can't modify or delete it.
     * 
     * @param level the level value to set.
     * @return the ManagementLockProperties object itself.
     */
    public ManagementLockProperties withLevel(LockLevel level) {
        this.level = level;
        return this;
    }

    /**
     * Get the notes property: Notes about the lock. Maximum of 512 characters.
     * 
     * @return the notes value.
     */
    public String notes() {
        return this.notes;
    }

    /**
     * Set the notes property: Notes about the lock. Maximum of 512 characters.
     * 
     * @param notes the notes value to set.
     * @return the ManagementLockProperties object itself.
     */
    public ManagementLockProperties withNotes(String notes) {
        this.notes = notes;
        return this;
    }

    /**
     * Get the owners property: The owners of the lock.
     * 
     * @return the owners value.
     */
    public List<ManagementLockOwner> owners() {
        return this.owners;
    }

    /**
     * Set the owners property: The owners of the lock.
     * 
     * @param owners the owners value to set.
     * @return the ManagementLockProperties object itself.
     */
    public ManagementLockProperties withOwners(List<ManagementLockOwner> owners) {
        this.owners = owners;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (level() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property level in model ManagementLockProperties"));
        }
        if (owners() != null) {
            owners().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagementLockProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("notes", this.notes);
        jsonWriter.writeArrayField("owners", this.owners, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagementLockProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagementLockProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagementLockProperties.
     */
    public static ManagementLockProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagementLockProperties deserializedManagementLockProperties = new ManagementLockProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("level".equals(fieldName)) {
                    deserializedManagementLockProperties.level = LockLevel.fromString(reader.getString());
                } else if ("notes".equals(fieldName)) {
                    deserializedManagementLockProperties.notes = reader.getString();
                } else if ("owners".equals(fieldName)) {
                    List<ManagementLockOwner> owners
                        = reader.readArray(reader1 -> ManagementLockOwner.fromJson(reader1));
                    deserializedManagementLockProperties.owners = owners;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagementLockProperties;
        });
    }
}
