/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.resources.fluent.DeploymentOperationsClient;
import com.azure.resourcemanager.resources.fluent.DeploymentsClient;
import com.azure.resourcemanager.resources.fluent.DeploymentsManagementClient;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import com.azure.resourcemanager.resources.implementation.DeploymentOperationsClientImpl;
import com.azure.resourcemanager.resources.implementation.DeploymentsClientImpl;
import com.azure.resourcemanager.resources.implementation.DeploymentsManagementClientBuilder;
import java.time.Duration;

@ServiceClient(builder=DeploymentsManagementClientBuilder.class)
public final class DeploymentsManagementClientImpl
extends AzureServiceClient
implements DeploymentsManagementClient {
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final DeploymentsClient deployments;
    private final DeploymentOperationsClient deploymentOperations;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public DeploymentsClient getDeployments() {
        return this.deployments;
    }

    @Override
    public DeploymentOperationsClient getDeploymentOperations() {
        return this.deploymentOperations;
    }

    DeploymentsManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2025-04-01";
        this.deployments = new DeploymentsClientImpl(this);
        this.deploymentOperations = new DeploymentOperationsClientImpl(this);
    }
}

