// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

/**
 * The subscription spending limit.
 */
public enum SpendingLimit {
    /**
     * Enum value On.
     */
    ON("On"),

    /**
     * Enum value Off.
     */
    OFF("Off"),

    /**
     * Enum value CurrentPeriodOff.
     */
    CURRENT_PERIOD_OFF("CurrentPeriodOff");

    /**
     * The actual serialized value for a SpendingLimit instance.
     */
    private final String value;

    SpendingLimit(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a SpendingLimit instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed SpendingLimit object, or null if unable to parse.
     */
    public static SpendingLimit fromString(String value) {
        if (value == null) {
            return null;
        }
        SpendingLimit[] items = SpendingLimit.values();
        for (SpendingLimit item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
