// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The provider extended location.
 */
@Fluent
public final class ProviderExtendedLocation implements JsonSerializable<ProviderExtendedLocation> {
    /*
     * The azure location.
     */
    private String location;

    /*
     * The extended location type.
     */
    private String type;

    /*
     * The extended locations for the azure location.
     */
    private List<String> extendedLocations;

    /**
     * Creates an instance of ProviderExtendedLocation class.
     */
    public ProviderExtendedLocation() {
    }

    /**
     * Get the location property: The azure location.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The azure location.
     * 
     * @param location the location value to set.
     * @return the ProviderExtendedLocation object itself.
     */
    public ProviderExtendedLocation withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the type property: The extended location type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The extended location type.
     * 
     * @param type the type value to set.
     * @return the ProviderExtendedLocation object itself.
     */
    public ProviderExtendedLocation withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the extendedLocations property: The extended locations for the azure location.
     * 
     * @return the extendedLocations value.
     */
    public List<String> extendedLocations() {
        return this.extendedLocations;
    }

    /**
     * Set the extendedLocations property: The extended locations for the azure location.
     * 
     * @param extendedLocations the extendedLocations value to set.
     * @return the ProviderExtendedLocation object itself.
     */
    public ProviderExtendedLocation withExtendedLocations(List<String> extendedLocations) {
        this.extendedLocations = extendedLocations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeArrayField("extendedLocations", this.extendedLocations,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProviderExtendedLocation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProviderExtendedLocation if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProviderExtendedLocation.
     */
    public static ProviderExtendedLocation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProviderExtendedLocation deserializedProviderExtendedLocation = new ProviderExtendedLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("location".equals(fieldName)) {
                    deserializedProviderExtendedLocation.location = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedProviderExtendedLocation.type = reader.getString();
                } else if ("extendedLocations".equals(fieldName)) {
                    List<String> extendedLocations = reader.readArray(reader1 -> reader1.getString());
                    deserializedProviderExtendedLocation.extendedLocations = extendedLocations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProviderExtendedLocation;
        });
    }
}
