// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The value of a parameter.
 */
@Fluent
public final class ParameterValuesValue implements JsonSerializable<ParameterValuesValue> {
    /*
     * The value of the parameter.
     */
    private Object value;

    /**
     * Creates an instance of ParameterValuesValue class.
     */
    public ParameterValuesValue() {
    }

    /**
     * Get the value property: The value of the parameter.
     * 
     * @return the value value.
     */
    public Object value() {
        return this.value;
    }

    /**
     * Set the value property: The value of the parameter.
     * 
     * @param value the value value to set.
     * @return the ParameterValuesValue object itself.
     */
    public ParameterValuesValue withValue(Object value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.value != null) {
            jsonWriter.writeUntypedField("value", this.value);
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ParameterValuesValue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ParameterValuesValue if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ParameterValuesValue.
     */
    public static ParameterValuesValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ParameterValuesValue deserializedParameterValuesValue = new ParameterValuesValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedParameterValuesValue.value = reader.readUntyped();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedParameterValuesValue;
        });
    }
}
