// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure Key Vault parameter reference.
 */
@Fluent
public final class KeyVaultParameterReference implements JsonSerializable<KeyVaultParameterReference> {
    /*
     * Azure Key Vault reference.
     */
    private KeyVaultReference keyVault;

    /*
     * Azure Key Vault secret name.
     */
    private String secretName;

    /*
     * Azure Key Vault secret version.
     */
    private String secretVersion;

    /**
     * Creates an instance of KeyVaultParameterReference class.
     */
    public KeyVaultParameterReference() {
    }

    /**
     * Get the keyVault property: Azure Key Vault reference.
     * 
     * @return the keyVault value.
     */
    public KeyVaultReference keyVault() {
        return this.keyVault;
    }

    /**
     * Set the keyVault property: Azure Key Vault reference.
     * 
     * @param keyVault the keyVault value to set.
     * @return the KeyVaultParameterReference object itself.
     */
    public KeyVaultParameterReference withKeyVault(KeyVaultReference keyVault) {
        this.keyVault = keyVault;
        return this;
    }

    /**
     * Get the secretName property: Azure Key Vault secret name.
     * 
     * @return the secretName value.
     */
    public String secretName() {
        return this.secretName;
    }

    /**
     * Set the secretName property: Azure Key Vault secret name.
     * 
     * @param secretName the secretName value to set.
     * @return the KeyVaultParameterReference object itself.
     */
    public KeyVaultParameterReference withSecretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    /**
     * Get the secretVersion property: Azure Key Vault secret version.
     * 
     * @return the secretVersion value.
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set the secretVersion property: Azure Key Vault secret version.
     * 
     * @param secretVersion the secretVersion value to set.
     * @return the KeyVaultParameterReference object itself.
     */
    public KeyVaultParameterReference withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyVault() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property keyVault in model KeyVaultParameterReference"));
        } else {
            keyVault().validate();
        }
        if (secretName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property secretName in model KeyVaultParameterReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultParameterReference.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("keyVault", this.keyVault);
        jsonWriter.writeStringField("secretName", this.secretName);
        jsonWriter.writeStringField("secretVersion", this.secretVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultParameterReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultParameterReference if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyVaultParameterReference.
     */
    public static KeyVaultParameterReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultParameterReference deserializedKeyVaultParameterReference = new KeyVaultParameterReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyVault".equals(fieldName)) {
                    deserializedKeyVaultParameterReference.keyVault = KeyVaultReference.fromJson(reader);
                } else if ("secretName".equals(fieldName)) {
                    deserializedKeyVaultParameterReference.secretName = reader.getString();
                } else if ("secretVersion".equals(fieldName)) {
                    deserializedKeyVaultParameterReference.secretVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultParameterReference;
        });
    }
}
