// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Deployment dependency information.
 */
@Fluent
public final class BasicDependency implements JsonSerializable<BasicDependency> {
    /*
     * The ID of the dependency.
     */
    private String id;

    /*
     * The dependency resource type.
     */
    private String resourceType;

    /*
     * The dependency resource name.
     */
    private String resourceName;

    /**
     * Creates an instance of BasicDependency class.
     */
    public BasicDependency() {
    }

    /**
     * Get the id property: The ID of the dependency.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The ID of the dependency.
     * 
     * @param id the id value to set.
     * @return the BasicDependency object itself.
     */
    public BasicDependency withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the resourceType property: The dependency resource type.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Set the resourceType property: The dependency resource type.
     * 
     * @param resourceType the resourceType value to set.
     * @return the BasicDependency object itself.
     */
    public BasicDependency withResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    /**
     * Get the resourceName property: The dependency resource name.
     * 
     * @return the resourceName value.
     */
    public String resourceName() {
        return this.resourceName;
    }

    /**
     * Set the resourceName property: The dependency resource name.
     * 
     * @param resourceName the resourceName value to set.
     * @return the BasicDependency object itself.
     */
    public BasicDependency withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("resourceType", this.resourceType);
        jsonWriter.writeStringField("resourceName", this.resourceName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BasicDependency from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BasicDependency if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BasicDependency.
     */
    public static BasicDependency fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BasicDependency deserializedBasicDependency = new BasicDependency();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedBasicDependency.id = reader.getString();
                } else if ("resourceType".equals(fieldName)) {
                    deserializedBasicDependency.resourceType = reader.getString();
                } else if ("resourceName".equals(fieldName)) {
                    deserializedBasicDependency.resourceName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBasicDependency;
        });
    }
}
