// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The resourceId extended model. This is used to document failed resources with a resourceId and a corresponding error.
 */
@Fluent
public final class ResourceReferenceExtended extends ResourceReference {
    /*
     * The error detail.
     */
    private ManagementError error;

    /*
     * The resourceId of a resource managed by the deployment stack.
     */
    private String id;

    /**
     * Creates an instance of ResourceReferenceExtended class.
     */
    public ResourceReferenceExtended() {
    }

    /**
     * Get the error property: The error detail.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Set the error property: The error detail.
     * 
     * @param error the error value to set.
     * @return the ResourceReferenceExtended object itself.
     */
    public ResourceReferenceExtended withError(ManagementError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the id property: The resourceId of a resource managed by the deployment stack.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("error", this.error);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceReferenceExtended from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceReferenceExtended if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResourceReferenceExtended.
     */
    public static ResourceReferenceExtended fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceReferenceExtended deserializedResourceReferenceExtended = new ResourceReferenceExtended();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedResourceReferenceExtended.id = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedResourceReferenceExtended.error = ManagementError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceReferenceExtended;
        });
    }
}
