// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Deployment on error behavior.
 */
@Fluent
public final class OnErrorDeployment implements JsonSerializable<OnErrorDeployment> {
    /*
     * The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
     */
    private OnErrorDeploymentType type;

    /*
     * The deployment to be used on error case.
     */
    private String deploymentName;

    /**
     * Creates an instance of OnErrorDeployment class.
     */
    public OnErrorDeployment() {
    }

    /**
     * Get the type property: The deployment on error behavior type. Possible values are LastSuccessful and
     * SpecificDeployment.
     * 
     * @return the type value.
     */
    public OnErrorDeploymentType type() {
        return this.type;
    }

    /**
     * Set the type property: The deployment on error behavior type. Possible values are LastSuccessful and
     * SpecificDeployment.
     * 
     * @param type the type value to set.
     * @return the OnErrorDeployment object itself.
     */
    public OnErrorDeployment withType(OnErrorDeploymentType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the deploymentName property: The deployment to be used on error case.
     * 
     * @return the deploymentName value.
     */
    public String deploymentName() {
        return this.deploymentName;
    }

    /**
     * Set the deploymentName property: The deployment to be used on error case.
     * 
     * @param deploymentName the deploymentName value to set.
     * @return the OnErrorDeployment object itself.
     */
    public OnErrorDeployment withDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("deploymentName", this.deploymentName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of OnErrorDeployment from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of OnErrorDeployment if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the OnErrorDeployment.
     */
    public static OnErrorDeployment fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            OnErrorDeployment deserializedOnErrorDeployment = new OnErrorDeployment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedOnErrorDeployment.type = OnErrorDeploymentType.fromString(reader.getString());
                } else if ("deploymentName".equals(fieldName)) {
                    deserializedOnErrorDeployment.deploymentName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedOnErrorDeployment;
        });
    }
}
