// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The alias type.
 */
@Fluent
public final class Alias implements JsonSerializable<Alias> {
    /*
     * The alias name.
     */
    private String name;

    /*
     * The paths for an alias.
     */
    private List<AliasPath> paths;

    /*
     * The type of the alias.
     */
    private AliasType type;

    /*
     * The default path for an alias.
     */
    private String defaultPath;

    /*
     * The default pattern for an alias.
     */
    private AliasPattern defaultPattern;

    /*
     * The default alias path metadata. Applies to the default path and to any alias path that doesn't have metadata
     */
    private AliasPathMetadata defaultMetadata;

    /**
     * Creates an instance of Alias class.
     */
    public Alias() {
    }

    /**
     * Get the name property: The alias name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The alias name.
     * 
     * @param name the name value to set.
     * @return the Alias object itself.
     */
    public Alias withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the paths property: The paths for an alias.
     * 
     * @return the paths value.
     */
    public List<AliasPath> paths() {
        return this.paths;
    }

    /**
     * Set the paths property: The paths for an alias.
     * 
     * @param paths the paths value to set.
     * @return the Alias object itself.
     */
    public Alias withPaths(List<AliasPath> paths) {
        this.paths = paths;
        return this;
    }

    /**
     * Get the type property: The type of the alias.
     * 
     * @return the type value.
     */
    public AliasType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the alias.
     * 
     * @param type the type value to set.
     * @return the Alias object itself.
     */
    public Alias withType(AliasType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the defaultPath property: The default path for an alias.
     * 
     * @return the defaultPath value.
     */
    public String defaultPath() {
        return this.defaultPath;
    }

    /**
     * Set the defaultPath property: The default path for an alias.
     * 
     * @param defaultPath the defaultPath value to set.
     * @return the Alias object itself.
     */
    public Alias withDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
        return this;
    }

    /**
     * Get the defaultPattern property: The default pattern for an alias.
     * 
     * @return the defaultPattern value.
     */
    public AliasPattern defaultPattern() {
        return this.defaultPattern;
    }

    /**
     * Set the defaultPattern property: The default pattern for an alias.
     * 
     * @param defaultPattern the defaultPattern value to set.
     * @return the Alias object itself.
     */
    public Alias withDefaultPattern(AliasPattern defaultPattern) {
        this.defaultPattern = defaultPattern;
        return this;
    }

    /**
     * Get the defaultMetadata property: The default alias path metadata. Applies to the default path and to any alias
     * path that doesn't have metadata.
     * 
     * @return the defaultMetadata value.
     */
    public AliasPathMetadata defaultMetadata() {
        return this.defaultMetadata;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (paths() != null) {
            paths().forEach(e -> e.validate());
        }
        if (defaultPattern() != null) {
            defaultPattern().validate();
        }
        if (defaultMetadata() != null) {
            defaultMetadata().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("paths", this.paths, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("defaultPath", this.defaultPath);
        jsonWriter.writeJsonField("defaultPattern", this.defaultPattern);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Alias from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Alias if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Alias.
     */
    public static Alias fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Alias deserializedAlias = new Alias();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAlias.name = reader.getString();
                } else if ("paths".equals(fieldName)) {
                    List<AliasPath> paths = reader.readArray(reader1 -> AliasPath.fromJson(reader1));
                    deserializedAlias.paths = paths;
                } else if ("type".equals(fieldName)) {
                    deserializedAlias.type = AliasType.fromString(reader.getString());
                } else if ("defaultPath".equals(fieldName)) {
                    deserializedAlias.defaultPath = reader.getString();
                } else if ("defaultPattern".equals(fieldName)) {
                    deserializedAlias.defaultPattern = AliasPattern.fromJson(reader);
                } else if ("defaultMetadata".equals(fieldName)) {
                    deserializedAlias.defaultMetadata = AliasPathMetadata.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlias;
        });
    }
}
