/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.KeyVaultParameterReference;
import java.io.IOException;

public final class DeploymentParameter
implements JsonSerializable<DeploymentParameter> {
    private Object value;
    private KeyVaultParameterReference reference;

    public Object value() {
        return this.value;
    }

    public DeploymentParameter withValue(Object value) {
        this.value = value;
        return this;
    }

    public KeyVaultParameterReference reference() {
        return this.reference;
    }

    public DeploymentParameter withReference(KeyVaultParameterReference reference) {
        this.reference = reference;
        return this;
    }

    public void validate() {
        if (this.reference() != null) {
            this.reference().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("value", this.value);
        jsonWriter.writeJsonField("reference", (JsonSerializable)this.reference);
        return jsonWriter.writeEndObject();
    }

    public static DeploymentParameter fromJson(JsonReader jsonReader) throws IOException {
        return (DeploymentParameter)jsonReader.readObject(reader -> {
            DeploymentParameter deserializedDeploymentParameter = new DeploymentParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedDeploymentParameter.value = reader.readUntyped();
                    continue;
                }
                if ("reference".equals(fieldName)) {
                    deserializedDeploymentParameter.reference = KeyVaultParameterReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeploymentParameter;
        });
    }
}

