// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.PolicySetDefinitionInner;
import java.io.IOException;
import java.util.List;

/**
 * List of policy set definitions.
 */
@Fluent
public final class PolicySetDefinitionListResult implements JsonSerializable<PolicySetDefinitionListResult> {
    /*
     * An array of policy set definitions.
     */
    private List<PolicySetDefinitionInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of PolicySetDefinitionListResult class.
     */
    public PolicySetDefinitionListResult() {
    }

    /**
     * Get the value property: An array of policy set definitions.
     * 
     * @return the value value.
     */
    public List<PolicySetDefinitionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of policy set definitions.
     * 
     * @param value the value value to set.
     * @return the PolicySetDefinitionListResult object itself.
     */
    public PolicySetDefinitionListResult withValue(List<PolicySetDefinitionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to use for getting the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PolicySetDefinitionListResult object itself.
     */
    public PolicySetDefinitionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicySetDefinitionListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicySetDefinitionListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicySetDefinitionListResult.
     */
    public static PolicySetDefinitionListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicySetDefinitionListResult deserializedPolicySetDefinitionListResult
                = new PolicySetDefinitionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PolicySetDefinitionInner> value
                        = reader.readArray(reader1 -> PolicySetDefinitionInner.fromJson(reader1));
                    deserializedPolicySetDefinitionListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPolicySetDefinitionListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicySetDefinitionListResult;
        });
    }
}
