// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.EnforcementMode;
import com.azure.resourcemanager.resources.models.NonComplianceMessage;
import com.azure.resourcemanager.resources.models.OverrideModel;
import com.azure.resourcemanager.resources.models.ParameterValuesValue;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The policy assignment properties.
 */
@Fluent
public final class PolicyAssignmentProperties implements JsonSerializable<PolicyAssignmentProperties> {
    /*
     * The display name of the policy assignment.
     */
    private String displayName;

    /*
     * The ID of the policy definition or policy set definition being assigned.
     */
    private String policyDefinitionId;

    /*
     * The version of the policy definition to use.
     */
    private String definitionVersion;

    /*
     * The latest version of the policy definition available. This is only present if requested via the $expand query
     * parameter.
     */
    private String latestDefinitionVersion;

    /*
     * The effective version of the policy definition in use. This is only present if requested via the $expand query
     * parameter.
     */
    private String effectiveDefinitionVersion;

    /*
     * The scope for the policy assignment.
     */
    private String scope;

    /*
     * The policy's excluded scopes.
     */
    private List<String> notScopes;

    /*
     * The parameter values for the assigned policy rule. The keys are the parameter names.
     */
    private Map<String, ParameterValuesValue> parameters;

    /*
     * This message will be part of response in case of policy violation.
     */
    private String description;

    /*
     * The policy assignment metadata. Metadata is an open ended object and is typically a collection of key value
     * pairs.
     */
    private Object metadata;

    /*
     * The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
     */
    private EnforcementMode enforcementMode;

    /*
     * The messages that describe why a resource is non-compliant with the policy.
     */
    private List<NonComplianceMessage> nonComplianceMessages;

    /*
     * The resource selector list to filter policies by resource properties.
     */
    private List<ResourceSelector> resourceSelectors;

    /*
     * The policy property value override.
     */
    private List<OverrideModel> overrides;

    /**
     * Creates an instance of PolicyAssignmentProperties class.
     */
    public PolicyAssignmentProperties() {
    }

    /**
     * Get the displayName property: The display name of the policy assignment.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the policy assignment.
     * 
     * @param displayName the displayName value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the policyDefinitionId property: The ID of the policy definition or policy set definition being assigned.
     * 
     * @return the policyDefinitionId value.
     */
    public String policyDefinitionId() {
        return this.policyDefinitionId;
    }

    /**
     * Set the policyDefinitionId property: The ID of the policy definition or policy set definition being assigned.
     * 
     * @param policyDefinitionId the policyDefinitionId value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withPolicyDefinitionId(String policyDefinitionId) {
        this.policyDefinitionId = policyDefinitionId;
        return this;
    }

    /**
     * Get the definitionVersion property: The version of the policy definition to use.
     * 
     * @return the definitionVersion value.
     */
    public String definitionVersion() {
        return this.definitionVersion;
    }

    /**
     * Set the definitionVersion property: The version of the policy definition to use.
     * 
     * @param definitionVersion the definitionVersion value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withDefinitionVersion(String definitionVersion) {
        this.definitionVersion = definitionVersion;
        return this;
    }

    /**
     * Get the latestDefinitionVersion property: The latest version of the policy definition available. This is only
     * present if requested via the $expand query parameter.
     * 
     * @return the latestDefinitionVersion value.
     */
    public String latestDefinitionVersion() {
        return this.latestDefinitionVersion;
    }

    /**
     * Get the effectiveDefinitionVersion property: The effective version of the policy definition in use. This is only
     * present if requested via the $expand query parameter.
     * 
     * @return the effectiveDefinitionVersion value.
     */
    public String effectiveDefinitionVersion() {
        return this.effectiveDefinitionVersion;
    }

    /**
     * Get the scope property: The scope for the policy assignment.
     * 
     * @return the scope value.
     */
    public String scope() {
        return this.scope;
    }

    /**
     * Get the notScopes property: The policy's excluded scopes.
     * 
     * @return the notScopes value.
     */
    public List<String> notScopes() {
        return this.notScopes;
    }

    /**
     * Set the notScopes property: The policy's excluded scopes.
     * 
     * @param notScopes the notScopes value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withNotScopes(List<String> notScopes) {
        this.notScopes = notScopes;
        return this;
    }

    /**
     * Get the parameters property: The parameter values for the assigned policy rule. The keys are the parameter names.
     * 
     * @return the parameters value.
     */
    public Map<String, ParameterValuesValue> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameter values for the assigned policy rule. The keys are the parameter names.
     * 
     * @param parameters the parameters value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withParameters(Map<String, ParameterValuesValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the description property: This message will be part of response in case of policy violation.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: This message will be part of response in case of policy violation.
     * 
     * @param description the description value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the metadata property: The policy assignment metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @return the metadata value.
     */
    public Object metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: The policy assignment metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @param metadata the metadata value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the enforcementMode property: The policy assignment enforcement mode. Possible values are Default and
     * DoNotEnforce.
     * 
     * @return the enforcementMode value.
     */
    public EnforcementMode enforcementMode() {
        return this.enforcementMode;
    }

    /**
     * Set the enforcementMode property: The policy assignment enforcement mode. Possible values are Default and
     * DoNotEnforce.
     * 
     * @param enforcementMode the enforcementMode value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withEnforcementMode(EnforcementMode enforcementMode) {
        this.enforcementMode = enforcementMode;
        return this;
    }

    /**
     * Get the nonComplianceMessages property: The messages that describe why a resource is non-compliant with the
     * policy.
     * 
     * @return the nonComplianceMessages value.
     */
    public List<NonComplianceMessage> nonComplianceMessages() {
        return this.nonComplianceMessages;
    }

    /**
     * Set the nonComplianceMessages property: The messages that describe why a resource is non-compliant with the
     * policy.
     * 
     * @param nonComplianceMessages the nonComplianceMessages value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withNonComplianceMessages(List<NonComplianceMessage> nonComplianceMessages) {
        this.nonComplianceMessages = nonComplianceMessages;
        return this;
    }

    /**
     * Get the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @return the resourceSelectors value.
     */
    public List<ResourceSelector> resourceSelectors() {
        return this.resourceSelectors;
    }

    /**
     * Set the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @param resourceSelectors the resourceSelectors value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        this.resourceSelectors = resourceSelectors;
        return this;
    }

    /**
     * Get the overrides property: The policy property value override.
     * 
     * @return the overrides value.
     */
    public List<OverrideModel> overrides() {
        return this.overrides;
    }

    /**
     * Set the overrides property: The policy property value override.
     * 
     * @param overrides the overrides value to set.
     * @return the PolicyAssignmentProperties object itself.
     */
    public PolicyAssignmentProperties withOverrides(List<OverrideModel> overrides) {
        this.overrides = overrides;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (parameters() != null) {
            parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (nonComplianceMessages() != null) {
            nonComplianceMessages().forEach(e -> e.validate());
        }
        if (resourceSelectors() != null) {
            resourceSelectors().forEach(e -> e.validate());
        }
        if (overrides() != null) {
            overrides().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("policyDefinitionId", this.policyDefinitionId);
        jsonWriter.writeStringField("definitionVersion", this.definitionVersion);
        jsonWriter.writeArrayField("notScopes", this.notScopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeUntypedField("metadata", this.metadata);
        jsonWriter.writeStringField("enforcementMode",
            this.enforcementMode == null ? null : this.enforcementMode.toString());
        jsonWriter.writeArrayField("nonComplianceMessages", this.nonComplianceMessages,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("resourceSelectors", this.resourceSelectors,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("overrides", this.overrides, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyAssignmentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyAssignmentProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PolicyAssignmentProperties.
     */
    public static PolicyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyAssignmentProperties deserializedPolicyAssignmentProperties = new PolicyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayName".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.displayName = reader.getString();
                } else if ("policyDefinitionId".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.policyDefinitionId = reader.getString();
                } else if ("definitionVersion".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.definitionVersion = reader.getString();
                } else if ("latestDefinitionVersion".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.latestDefinitionVersion = reader.getString();
                } else if ("effectiveDefinitionVersion".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.effectiveDefinitionVersion = reader.getString();
                } else if ("scope".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.scope = reader.getString();
                } else if ("notScopes".equals(fieldName)) {
                    List<String> notScopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedPolicyAssignmentProperties.notScopes = notScopes;
                } else if ("parameters".equals(fieldName)) {
                    Map<String, ParameterValuesValue> parameters
                        = reader.readMap(reader1 -> ParameterValuesValue.fromJson(reader1));
                    deserializedPolicyAssignmentProperties.parameters = parameters;
                } else if ("description".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.description = reader.getString();
                } else if ("metadata".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.metadata = reader.readUntyped();
                } else if ("enforcementMode".equals(fieldName)) {
                    deserializedPolicyAssignmentProperties.enforcementMode
                        = EnforcementMode.fromString(reader.getString());
                } else if ("nonComplianceMessages".equals(fieldName)) {
                    List<NonComplianceMessage> nonComplianceMessages
                        = reader.readArray(reader1 -> NonComplianceMessage.fromJson(reader1));
                    deserializedPolicyAssignmentProperties.nonComplianceMessages = nonComplianceMessages;
                } else if ("resourceSelectors".equals(fieldName)) {
                    List<ResourceSelector> resourceSelectors
                        = reader.readArray(reader1 -> ResourceSelector.fromJson(reader1));
                    deserializedPolicyAssignmentProperties.resourceSelectors = resourceSelectors;
                } else if ("overrides".equals(fieldName)) {
                    List<OverrideModel> overrides = reader.readArray(reader1 -> OverrideModel.fromJson(reader1));
                    deserializedPolicyAssignmentProperties.overrides = overrides;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyAssignmentProperties;
        });
    }
}
