// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ChangeProperties;
import java.io.IOException;

/**
 * Change Resource.
 */
@Fluent
public final class ChangeResourceResultInner extends ProxyResource {
    /*
     * The properties of a change
     */
    private ChangeProperties properties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ChangeResourceResultInner class.
     */
    public ChangeResourceResultInner() {
    }

    /**
     * Get the properties property: The properties of a change.
     * 
     * @return the properties value.
     */
    public ChangeProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The properties of a change.
     * 
     * @param properties the properties value to set.
     * @return the ChangeResourceResultInner object itself.
     */
    public ChangeResourceResultInner withProperties(ChangeProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChangeResourceResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChangeResourceResultInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ChangeResourceResultInner.
     */
    public static ChangeResourceResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChangeResourceResultInner deserializedChangeResourceResultInner = new ChangeResourceResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedChangeResourceResultInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedChangeResourceResultInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedChangeResourceResultInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedChangeResourceResultInner.properties = ChangeProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedChangeResourceResultInner;
        });
    }
}
