// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ParameterDefinitionsValue;
import com.azure.resourcemanager.resources.models.PolicyType;
import java.io.IOException;
import java.util.Map;

/**
 * The policy definition.
 */
@Fluent
public final class PolicyDefinitionInner extends ProxyResource {
    /*
     * The policy definition properties.
     */
    private PolicyDefinitionProperties innerProperties;

    /*
     * The system metadata relating to this resource.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of PolicyDefinitionInner class.
     */
    public PolicyDefinitionInner() {
    }

    /**
     * Get the innerProperties property: The policy definition properties.
     * 
     * @return the innerProperties value.
     */
    private PolicyDefinitionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata relating to this resource.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the policyType property: The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom,
     * and Static.
     * 
     * @return the policyType value.
     */
    public PolicyType policyType() {
        return this.innerProperties() == null ? null : this.innerProperties().policyType();
    }

    /**
     * Set the policyType property: The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom,
     * and Static.
     * 
     * @param policyType the policyType value to set.
     * @return the PolicyDefinitionInner object itself.
     */
    public PolicyDefinitionInner withPolicyType(PolicyType policyType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyDefinitionProperties();
        }
        this.innerProperties().withPolicyType(policyType);
        return this;
    }

    /**
     * Get the mode property: The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     * 
     * @return the mode value.
     */
    public String mode() {
        return this.innerProperties() == null ? null : this.innerProperties().mode();
    }

    /**
     * Set the mode property: The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     * 
     * @param mode the mode value to set.
     * @return the PolicyDefinitionInner object itself.
     */
    public PolicyDefinitionInner withMode(String mode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyDefinitionProperties();
        }
        this.innerProperties().withMode(mode);
        return this;
    }

    /**
     * Get the displayName property: The display name of the policy definition.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Set the displayName property: The display name of the policy definition.
     * 
     * @param displayName the displayName value to set.
     * @return the PolicyDefinitionInner object itself.
     */
    public PolicyDefinitionInner withDisplayName(String displayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyDefinitionProperties();
        }
        this.innerProperties().withDisplayName(displayName);
        return this;
    }

    /**
     * Get the description property: The policy definition description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The policy definition description.
     * 
     * @param description the description value to set.
     * @return the PolicyDefinitionInner object itself.
     */
    public PolicyDefinitionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyDefinitionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the policyRule property: The policy rule.
     * 
     * @return the policyRule value.
     */
    public Object policyRule() {
        return this.innerProperties() == null ? null : this.innerProperties().policyRule();
    }

    /**
     * Set the policyRule property: The policy rule.
     * 
     * @param policyRule the policyRule value to set.
     * @return the PolicyDefinitionInner object itself.
     */
    public PolicyDefinitionInner withPolicyRule(Object policyRule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyDefinitionProperties();
        }
        this.innerProperties().withPolicyRule(policyRule);
        return this;
    }

    /**
     * Get the metadata property: The policy definition metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @return the metadata value.
     */
    public Object metadata() {
        return this.innerProperties() == null ? null : this.innerProperties().metadata();
    }

    /**
     * Set the metadata property: The policy definition metadata. Metadata is an open ended object and is typically a
     * collection of key value pairs.
     * 
     * @param metadata the metadata value to set.
     * @return the PolicyDefinitionInner object itself.
     */
    public PolicyDefinitionInner withMetadata(Object metadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyDefinitionProperties();
        }
        this.innerProperties().withMetadata(metadata);
        return this;
    }

    /**
     * Get the parameters property: The parameter definitions for parameters used in the policy rule. The keys are the
     * parameter names.
     * 
     * @return the parameters value.
     */
    public Map<String, ParameterDefinitionsValue> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    /**
     * Set the parameters property: The parameter definitions for parameters used in the policy rule. The keys are the
     * parameter names.
     * 
     * @param parameters the parameters value to set.
     * @return the PolicyDefinitionInner object itself.
     */
    public PolicyDefinitionInner withParameters(Map<String, ParameterDefinitionsValue> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PolicyDefinitionProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PolicyDefinitionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PolicyDefinitionInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PolicyDefinitionInner.
     */
    public static PolicyDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PolicyDefinitionInner deserializedPolicyDefinitionInner = new PolicyDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPolicyDefinitionInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPolicyDefinitionInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPolicyDefinitionInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedPolicyDefinitionInner.innerProperties = PolicyDefinitionProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedPolicyDefinitionInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPolicyDefinitionInner;
        });
    }
}
