// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information about a tenant managing the subscription.
 */
@Immutable
public final class ManagedByTenant implements JsonSerializable<ManagedByTenant> {
    /*
     * The tenant ID of the managing tenant. This is a GUID.
     */
    private String tenantId;

    /**
     * Creates an instance of ManagedByTenant class.
     */
    public ManagedByTenant() {
    }

    /**
     * Get the tenantId property: The tenant ID of the managing tenant. This is a GUID.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedByTenant from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedByTenant if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedByTenant.
     */
    public static ManagedByTenant fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedByTenant deserializedManagedByTenant = new ManagedByTenant();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tenantId".equals(fieldName)) {
                    deserializedManagedByTenant.tenantId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedByTenant;
        });
    }
}
