// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure Key Vault reference.
 */
@Fluent
public final class KeyVaultReference implements JsonSerializable<KeyVaultReference> {
    /*
     * Azure Key Vault resource id.
     */
    private String id;

    /**
     * Creates an instance of KeyVaultReference class.
     */
    public KeyVaultReference() {
    }

    /**
     * Get the id property: Azure Key Vault resource id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Azure Key Vault resource id.
     * 
     * @param id the id value to set.
     * @return the KeyVaultReference object itself.
     */
    public KeyVaultReference withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model KeyVaultReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultReference.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultReference if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyVaultReference.
     */
    public static KeyVaultReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultReference deserializedKeyVaultReference = new KeyVaultReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedKeyVaultReference.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultReference;
        });
    }
}
