// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

/**
 * Type of change that will be made to the resource when the deployment is executed.
 */
public enum ChangeType {
    /**
     * Enum value Create.
     */
    CREATE("Create"),

    /**
     * Enum value Delete.
     */
    DELETE("Delete"),

    /**
     * Enum value Ignore.
     */
    IGNORE("Ignore"),

    /**
     * Enum value Deploy.
     */
    DEPLOY("Deploy"),

    /**
     * Enum value NoChange.
     */
    NO_CHANGE("NoChange"),

    /**
     * Enum value Modify.
     */
    MODIFY("Modify"),

    /**
     * Enum value Unsupported.
     */
    UNSUPPORTED("Unsupported");

    /**
     * The actual serialized value for a ChangeType instance.
     */
    private final String value;

    ChangeType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ChangeType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ChangeType object, or null if unable to parse.
     */
    public static ChangeType fromString(String value) {
        if (value == null) {
            return null;
        }
        ChangeType[] items = ChangeType.values();
        for (ChangeType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
