// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.Tags;
import java.io.IOException;

/**
 * Wrapper resource for tags API requests and responses.
 */
@Fluent
public final class TagsResourceInner extends ProxyResource {
    /*
     * The set of tags.
     */
    private Tags properties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of TagsResourceInner class.
     */
    public TagsResourceInner() {
    }

    /**
     * Get the properties property: The set of tags.
     * 
     * @return the properties value.
     */
    public Tags properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The set of tags.
     * 
     * @param properties the properties value to set.
     * @return the TagsResourceInner object itself.
     */
    public TagsResourceInner withProperties(Tags properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property properties in model TagsResourceInner"));
        } else {
            properties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TagsResourceInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TagsResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TagsResourceInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TagsResourceInner.
     */
    public static TagsResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TagsResourceInner deserializedTagsResourceInner = new TagsResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedTagsResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedTagsResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedTagsResourceInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedTagsResourceInner.properties = Tags.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTagsResourceInner;
        });
    }
}
