// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.ChangeResourceResultInner;
import java.io.IOException;
import java.util.List;

/**
 * The list of resources.
 */
@Fluent
public final class ChangeResourceListResult implements JsonSerializable<ChangeResourceListResult> {
    /*
     * The link used to get the next page of Change Resources
     */
    private String nextLink;

    /*
     * The list of resources
     */
    private List<ChangeResourceResultInner> value;

    /**
     * Creates an instance of ChangeResourceListResult class.
     */
    public ChangeResourceListResult() {
    }

    /**
     * Get the nextLink property: The link used to get the next page of Change Resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The link used to get the next page of Change Resources.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ChangeResourceListResult object itself.
     */
    public ChangeResourceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Get the value property: The list of resources.
     * 
     * @return the value value.
     */
    public List<ChangeResourceResultInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of resources.
     * 
     * @param value the value value to set.
     * @return the ChangeResourceListResult object itself.
     */
    public ChangeResourceListResult withValue(List<ChangeResourceResultInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ChangeResourceListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ChangeResourceListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ChangeResourceListResult.
     */
    public static ChangeResourceListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ChangeResourceListResult deserializedChangeResourceListResult = new ChangeResourceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nextLink".equals(fieldName)) {
                    deserializedChangeResourceListResult.nextLink = reader.getString();
                } else if ("value".equals(fieldName)) {
                    List<ChangeResourceResultInner> value
                        = reader.readArray(reader1 -> ChangeResourceResultInner.fromJson(reader1));
                    deserializedChangeResourceListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedChangeResourceListResult;
        });
    }
}
