// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.ProviderPermission;
import java.io.IOException;
import java.util.List;

/**
 * List of provider permissions.
 */
@Fluent
public final class ProviderPermissionListResultInner implements JsonSerializable<ProviderPermissionListResultInner> {
    /*
     * An array of provider permissions.
     */
    private List<ProviderPermission> value;

    /*
     * The URL to use for getting the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ProviderPermissionListResultInner class.
     */
    public ProviderPermissionListResultInner() {
    }

    /**
     * Get the value property: An array of provider permissions.
     * 
     * @return the value value.
     */
    public List<ProviderPermission> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of provider permissions.
     * 
     * @param value the value value to set.
     * @return the ProviderPermissionListResultInner object itself.
     */
    public ProviderPermissionListResultInner withValue(List<ProviderPermission> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProviderPermissionListResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProviderPermissionListResultInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProviderPermissionListResultInner.
     */
    public static ProviderPermissionListResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProviderPermissionListResultInner deserializedProviderPermissionListResultInner
                = new ProviderPermissionListResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ProviderPermission> value = reader.readArray(reader1 -> ProviderPermission.fromJson(reader1));
                    deserializedProviderPermissionListResultInner.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedProviderPermissionListResultInner.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProviderPermissionListResultInner;
        });
    }
}
