// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.models.DataEffect;
import com.azure.resourcemanager.resources.models.DataManifestCustomResourceFunctionDefinition;
import com.azure.resourcemanager.resources.models.ResourceTypeAliases;
import java.io.IOException;
import java.util.List;

/**
 * The properties of the data policy manifest.
 */
@Fluent
public final class DataPolicyManifestProperties implements JsonSerializable<DataPolicyManifestProperties> {
    /*
     * The list of namespaces for the data policy manifest.
     */
    private List<String> namespaces;

    /*
     * The policy mode of the data policy manifest.
     */
    private String policyMode;

    /*
     * A value indicating whether policy mode is allowed only in built-in definitions.
     */
    private Boolean isBuiltInOnly;

    /*
     * An array of resource type aliases.
     */
    private List<ResourceTypeAliases> resourceTypeAliases;

    /*
     * The effect definition.
     */
    private List<DataEffect> effects;

    /*
     * The non-alias field accessor values that can be used in the policy rule.
     */
    private List<String> fieldValues;

    /*
     * The resource functions definition specified in the data manifest.
     */
    private DataManifestResourceFunctionsDefinition innerResourceFunctions;

    /**
     * Creates an instance of DataPolicyManifestProperties class.
     */
    public DataPolicyManifestProperties() {
    }

    /**
     * Get the namespaces property: The list of namespaces for the data policy manifest.
     * 
     * @return the namespaces value.
     */
    public List<String> namespaces() {
        return this.namespaces;
    }

    /**
     * Set the namespaces property: The list of namespaces for the data policy manifest.
     * 
     * @param namespaces the namespaces value to set.
     * @return the DataPolicyManifestProperties object itself.
     */
    public DataPolicyManifestProperties withNamespaces(List<String> namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    /**
     * Get the policyMode property: The policy mode of the data policy manifest.
     * 
     * @return the policyMode value.
     */
    public String policyMode() {
        return this.policyMode;
    }

    /**
     * Set the policyMode property: The policy mode of the data policy manifest.
     * 
     * @param policyMode the policyMode value to set.
     * @return the DataPolicyManifestProperties object itself.
     */
    public DataPolicyManifestProperties withPolicyMode(String policyMode) {
        this.policyMode = policyMode;
        return this;
    }

    /**
     * Get the isBuiltInOnly property: A value indicating whether policy mode is allowed only in built-in definitions.
     * 
     * @return the isBuiltInOnly value.
     */
    public Boolean isBuiltInOnly() {
        return this.isBuiltInOnly;
    }

    /**
     * Set the isBuiltInOnly property: A value indicating whether policy mode is allowed only in built-in definitions.
     * 
     * @param isBuiltInOnly the isBuiltInOnly value to set.
     * @return the DataPolicyManifestProperties object itself.
     */
    public DataPolicyManifestProperties withIsBuiltInOnly(Boolean isBuiltInOnly) {
        this.isBuiltInOnly = isBuiltInOnly;
        return this;
    }

    /**
     * Get the resourceTypeAliases property: An array of resource type aliases.
     * 
     * @return the resourceTypeAliases value.
     */
    public List<ResourceTypeAliases> resourceTypeAliases() {
        return this.resourceTypeAliases;
    }

    /**
     * Set the resourceTypeAliases property: An array of resource type aliases.
     * 
     * @param resourceTypeAliases the resourceTypeAliases value to set.
     * @return the DataPolicyManifestProperties object itself.
     */
    public DataPolicyManifestProperties withResourceTypeAliases(List<ResourceTypeAliases> resourceTypeAliases) {
        this.resourceTypeAliases = resourceTypeAliases;
        return this;
    }

    /**
     * Get the effects property: The effect definition.
     * 
     * @return the effects value.
     */
    public List<DataEffect> effects() {
        return this.effects;
    }

    /**
     * Set the effects property: The effect definition.
     * 
     * @param effects the effects value to set.
     * @return the DataPolicyManifestProperties object itself.
     */
    public DataPolicyManifestProperties withEffects(List<DataEffect> effects) {
        this.effects = effects;
        return this;
    }

    /**
     * Get the fieldValues property: The non-alias field accessor values that can be used in the policy rule.
     * 
     * @return the fieldValues value.
     */
    public List<String> fieldValues() {
        return this.fieldValues;
    }

    /**
     * Set the fieldValues property: The non-alias field accessor values that can be used in the policy rule.
     * 
     * @param fieldValues the fieldValues value to set.
     * @return the DataPolicyManifestProperties object itself.
     */
    public DataPolicyManifestProperties withFieldValues(List<String> fieldValues) {
        this.fieldValues = fieldValues;
        return this;
    }

    /**
     * Get the innerResourceFunctions property: The resource functions definition specified in the data manifest.
     * 
     * @return the innerResourceFunctions value.
     */
    private DataManifestResourceFunctionsDefinition innerResourceFunctions() {
        return this.innerResourceFunctions;
    }

    /**
     * Get the standard property: The standard resource functions (subscription and/or resourceGroup).
     * 
     * @return the standard value.
     */
    public List<String> standard() {
        return this.innerResourceFunctions() == null ? null : this.innerResourceFunctions().standard();
    }

    /**
     * Set the standard property: The standard resource functions (subscription and/or resourceGroup).
     * 
     * @param standard the standard value to set.
     * @return the DataPolicyManifestProperties object itself.
     */
    public DataPolicyManifestProperties withStandard(List<String> standard) {
        if (this.innerResourceFunctions() == null) {
            this.innerResourceFunctions = new DataManifestResourceFunctionsDefinition();
        }
        this.innerResourceFunctions().withStandard(standard);
        return this;
    }

    /**
     * Get the custom property: An array of data manifest custom resource definition.
     * 
     * @return the custom value.
     */
    public List<DataManifestCustomResourceFunctionDefinition> custom() {
        return this.innerResourceFunctions() == null ? null : this.innerResourceFunctions().custom();
    }

    /**
     * Set the custom property: An array of data manifest custom resource definition.
     * 
     * @param custom the custom value to set.
     * @return the DataPolicyManifestProperties object itself.
     */
    public DataPolicyManifestProperties withCustom(List<DataManifestCustomResourceFunctionDefinition> custom) {
        if (this.innerResourceFunctions() == null) {
            this.innerResourceFunctions = new DataManifestResourceFunctionsDefinition();
        }
        this.innerResourceFunctions().withCustom(custom);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceTypeAliases() != null) {
            resourceTypeAliases().forEach(e -> e.validate());
        }
        if (effects() != null) {
            effects().forEach(e -> e.validate());
        }
        if (innerResourceFunctions() != null) {
            innerResourceFunctions().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("namespaces", this.namespaces, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("policyMode", this.policyMode);
        jsonWriter.writeBooleanField("isBuiltInOnly", this.isBuiltInOnly);
        jsonWriter.writeArrayField("resourceTypeAliases", this.resourceTypeAliases,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("effects", this.effects, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("fieldValues", this.fieldValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("resourceFunctions", this.innerResourceFunctions);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataPolicyManifestProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataPolicyManifestProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataPolicyManifestProperties.
     */
    public static DataPolicyManifestProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataPolicyManifestProperties deserializedDataPolicyManifestProperties = new DataPolicyManifestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("namespaces".equals(fieldName)) {
                    List<String> namespaces = reader.readArray(reader1 -> reader1.getString());
                    deserializedDataPolicyManifestProperties.namespaces = namespaces;
                } else if ("policyMode".equals(fieldName)) {
                    deserializedDataPolicyManifestProperties.policyMode = reader.getString();
                } else if ("isBuiltInOnly".equals(fieldName)) {
                    deserializedDataPolicyManifestProperties.isBuiltInOnly = reader.getNullable(JsonReader::getBoolean);
                } else if ("resourceTypeAliases".equals(fieldName)) {
                    List<ResourceTypeAliases> resourceTypeAliases
                        = reader.readArray(reader1 -> ResourceTypeAliases.fromJson(reader1));
                    deserializedDataPolicyManifestProperties.resourceTypeAliases = resourceTypeAliases;
                } else if ("effects".equals(fieldName)) {
                    List<DataEffect> effects = reader.readArray(reader1 -> DataEffect.fromJson(reader1));
                    deserializedDataPolicyManifestProperties.effects = effects;
                } else if ("fieldValues".equals(fieldName)) {
                    List<String> fieldValues = reader.readArray(reader1 -> reader1.getString());
                    deserializedDataPolicyManifestProperties.fieldValues = fieldValues;
                } else if ("resourceFunctions".equals(fieldName)) {
                    deserializedDataPolicyManifestProperties.innerResourceFunctions
                        = DataManifestResourceFunctionsDefinition.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataPolicyManifestProperties;
        });
    }
}
