// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.ProviderInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Deployment properties with additional details.
 */
@Immutable
public final class DeploymentPropertiesExtended implements JsonSerializable<DeploymentPropertiesExtended> {
    /*
     * Denotes the state of provisioning.
     */
    private ProvisioningState provisioningState;

    /*
     * The correlation ID of the deployment.
     */
    private String correlationId;

    /*
     * The timestamp of the template deployment.
     */
    private OffsetDateTime timestamp;

    /*
     * The duration of the template deployment.
     */
    private String duration;

    /*
     * Key/value pairs that represent deployment output.
     */
    private Object outputs;

    /*
     * The list of resource providers needed for the deployment.
     */
    private List<ProviderInner> providers;

    /*
     * The list of deployment dependencies.
     */
    private List<Dependency> dependencies;

    /*
     * The URI referencing the template.
     */
    private TemplateLink templateLink;

    /*
     * Deployment parameters.
     */
    private Object parameters;

    /*
     * The URI referencing the parameters.
     */
    private ParametersLink parametersLink;

    /*
     * The deployment mode. Possible values are Incremental and Complete.
     */
    private DeploymentMode mode;

    /*
     * The debug setting of the deployment.
     */
    private DebugSetting debugSetting;

    /*
     * The deployment on error behavior.
     */
    private OnErrorDeploymentExtended onErrorDeployment;

    /*
     * The hash produced for the template.
     */
    private String templateHash;

    /*
     * Array of provisioned resources.
     */
    private List<ResourceReference> outputResources;

    /*
     * Array of validated resources.
     */
    private List<ResourceReference> validatedResources;

    /*
     * The deployment error.
     */
    private ManagementError error;

    /**
     * Creates an instance of DeploymentPropertiesExtended class.
     */
    public DeploymentPropertiesExtended() {
    }

    /**
     * Get the provisioningState property: Denotes the state of provisioning.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the correlationId property: The correlation ID of the deployment.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Get the timestamp property: The timestamp of the template deployment.
     * 
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    /**
     * Get the duration property: The duration of the template deployment.
     * 
     * @return the duration value.
     */
    public String duration() {
        return this.duration;
    }

    /**
     * Get the outputs property: Key/value pairs that represent deployment output.
     * 
     * @return the outputs value.
     */
    public Object outputs() {
        return this.outputs;
    }

    /**
     * Get the providers property: The list of resource providers needed for the deployment.
     * 
     * @return the providers value.
     */
    public List<ProviderInner> providers() {
        return this.providers;
    }

    /**
     * Get the dependencies property: The list of deployment dependencies.
     * 
     * @return the dependencies value.
     */
    public List<Dependency> dependencies() {
        return this.dependencies;
    }

    /**
     * Get the templateLink property: The URI referencing the template.
     * 
     * @return the templateLink value.
     */
    public TemplateLink templateLink() {
        return this.templateLink;
    }

    /**
     * Get the parameters property: Deployment parameters.
     * 
     * @return the parameters value.
     */
    public Object parameters() {
        return this.parameters;
    }

    /**
     * Get the parametersLink property: The URI referencing the parameters.
     * 
     * @return the parametersLink value.
     */
    public ParametersLink parametersLink() {
        return this.parametersLink;
    }

    /**
     * Get the mode property: The deployment mode. Possible values are Incremental and Complete.
     * 
     * @return the mode value.
     */
    public DeploymentMode mode() {
        return this.mode;
    }

    /**
     * Get the debugSetting property: The debug setting of the deployment.
     * 
     * @return the debugSetting value.
     */
    public DebugSetting debugSetting() {
        return this.debugSetting;
    }

    /**
     * Get the onErrorDeployment property: The deployment on error behavior.
     * 
     * @return the onErrorDeployment value.
     */
    public OnErrorDeploymentExtended onErrorDeployment() {
        return this.onErrorDeployment;
    }

    /**
     * Get the templateHash property: The hash produced for the template.
     * 
     * @return the templateHash value.
     */
    public String templateHash() {
        return this.templateHash;
    }

    /**
     * Get the outputResources property: Array of provisioned resources.
     * 
     * @return the outputResources value.
     */
    public List<ResourceReference> outputResources() {
        return this.outputResources;
    }

    /**
     * Get the validatedResources property: Array of validated resources.
     * 
     * @return the validatedResources value.
     */
    public List<ResourceReference> validatedResources() {
        return this.validatedResources;
    }

    /**
     * Get the error property: The deployment error.
     * 
     * @return the error value.
     */
    public ManagementError error() {
        return this.error;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (providers() != null) {
            providers().forEach(e -> e.validate());
        }
        if (dependencies() != null) {
            dependencies().forEach(e -> e.validate());
        }
        if (templateLink() != null) {
            templateLink().validate();
        }
        if (parametersLink() != null) {
            parametersLink().validate();
        }
        if (debugSetting() != null) {
            debugSetting().validate();
        }
        if (onErrorDeployment() != null) {
            onErrorDeployment().validate();
        }
        if (outputResources() != null) {
            outputResources().forEach(e -> e.validate());
        }
        if (validatedResources() != null) {
            validatedResources().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DeploymentPropertiesExtended from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DeploymentPropertiesExtended if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DeploymentPropertiesExtended.
     */
    public static DeploymentPropertiesExtended fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DeploymentPropertiesExtended deserializedDeploymentPropertiesExtended = new DeploymentPropertiesExtended();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("correlationId".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.correlationId = reader.getString();
                } else if ("timestamp".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.timestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("duration".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.duration = reader.getString();
                } else if ("outputs".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.outputs = reader.readUntyped();
                } else if ("providers".equals(fieldName)) {
                    List<ProviderInner> providers = reader.readArray(reader1 -> ProviderInner.fromJson(reader1));
                    deserializedDeploymentPropertiesExtended.providers = providers;
                } else if ("dependencies".equals(fieldName)) {
                    List<Dependency> dependencies = reader.readArray(reader1 -> Dependency.fromJson(reader1));
                    deserializedDeploymentPropertiesExtended.dependencies = dependencies;
                } else if ("templateLink".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.templateLink = TemplateLink.fromJson(reader);
                } else if ("parameters".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.parameters = reader.readUntyped();
                } else if ("parametersLink".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.parametersLink = ParametersLink.fromJson(reader);
                } else if ("mode".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.mode = DeploymentMode.fromString(reader.getString());
                } else if ("debugSetting".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.debugSetting = DebugSetting.fromJson(reader);
                } else if ("onErrorDeployment".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.onErrorDeployment
                        = OnErrorDeploymentExtended.fromJson(reader);
                } else if ("templateHash".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.templateHash = reader.getString();
                } else if ("outputResources".equals(fieldName)) {
                    List<ResourceReference> outputResources
                        = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedDeploymentPropertiesExtended.outputResources = outputResources;
                } else if ("validatedResources".equals(fieldName)) {
                    List<ResourceReference> validatedResources
                        = reader.readArray(reader1 -> ResourceReference.fromJson(reader1));
                    deserializedDeploymentPropertiesExtended.validatedResources = validatedResources;
                } else if ("error".equals(fieldName)) {
                    deserializedDeploymentPropertiesExtended.error = ManagementError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDeploymentPropertiesExtended;
        });
    }
}
