// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.resources.fluent.models.TenantIdDescriptionInner;
import java.io.IOException;
import java.util.List;

/**
 * Tenant Ids information.
 */
@Fluent
public final class TenantListResult implements JsonSerializable<TenantListResult> {
    /*
     * An array of tenants.
     */
    private List<TenantIdDescriptionInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of TenantListResult class.
     */
    public TenantListResult() {
    }

    /**
     * Get the value property: An array of tenants.
     * 
     * @return the value value.
     */
    public List<TenantIdDescriptionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: An array of tenants.
     * 
     * @param value the value value to set.
     * @return the TenantListResult object itself.
     */
    public TenantListResult withValue(List<TenantIdDescriptionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to use for getting the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the TenantListResult object itself.
     */
    public TenantListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
        if (nextLink() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property nextLink in model TenantListResult"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TenantListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TenantListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TenantListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TenantListResult.
     */
    public static TenantListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TenantListResult deserializedTenantListResult = new TenantListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("nextLink".equals(fieldName)) {
                    deserializedTenantListResult.nextLink = reader.getString();
                } else if ("value".equals(fieldName)) {
                    List<TenantIdDescriptionInner> value
                        = reader.readArray(reader1 -> TenantIdDescriptionInner.fromJson(reader1));
                    deserializedTenantListResult.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTenantListResult;
        });
    }
}
