// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The ZoneMapping model.
 */
@Fluent
public final class ZoneMapping {
    /*
     * The location of the zone mapping.
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * The zones property.
     */
    @JsonProperty(value = "zones")
    private List<String> zones;

    /**
     * Creates an instance of ZoneMapping class.
     */
    public ZoneMapping() {
    }

    /**
     * Get the location property: The location of the zone mapping.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The location of the zone mapping.
     * 
     * @param location the location value to set.
     * @return the ZoneMapping object itself.
     */
    public ZoneMapping withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the zones property: The zones property.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Set the zones property: The zones property.
     * 
     * @param zones the zones value to set.
     * @return the ZoneMapping object itself.
     */
    public ZoneMapping withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
