// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Role definition permissions.
 */
@Fluent
public final class Permission {
    /*
     * Allowed actions.
     */
    @JsonProperty(value = "actions")
    private List<String> actions;

    /*
     * Denied actions.
     */
    @JsonProperty(value = "notActions")
    private List<String> notActions;

    /*
     * Allowed Data actions.
     */
    @JsonProperty(value = "dataActions")
    private List<String> dataActions;

    /*
     * Denied Data actions.
     */
    @JsonProperty(value = "notDataActions")
    private List<String> notDataActions;

    /**
     * Creates an instance of Permission class.
     */
    public Permission() {
    }

    /**
     * Get the actions property: Allowed actions.
     * 
     * @return the actions value.
     */
    public List<String> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: Allowed actions.
     * 
     * @param actions the actions value to set.
     * @return the Permission object itself.
     */
    public Permission withActions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the notActions property: Denied actions.
     * 
     * @return the notActions value.
     */
    public List<String> notActions() {
        return this.notActions;
    }

    /**
     * Set the notActions property: Denied actions.
     * 
     * @param notActions the notActions value to set.
     * @return the Permission object itself.
     */
    public Permission withNotActions(List<String> notActions) {
        this.notActions = notActions;
        return this;
    }

    /**
     * Get the dataActions property: Allowed Data actions.
     * 
     * @return the dataActions value.
     */
    public List<String> dataActions() {
        return this.dataActions;
    }

    /**
     * Set the dataActions property: Allowed Data actions.
     * 
     * @param dataActions the dataActions value to set.
     * @return the Permission object itself.
     */
    public Permission withDataActions(List<String> dataActions) {
        this.dataActions = dataActions;
        return this;
    }

    /**
     * Get the notDataActions property: Denied Data actions.
     * 
     * @return the notDataActions value.
     */
    public List<String> notDataActions() {
        return this.notDataActions;
    }

    /**
     * Set the notDataActions property: Denied Data actions.
     * 
     * @param notDataActions the notDataActions value to set.
     * @return the Permission object itself.
     */
    public Permission withNotDataActions(List<String> notDataActions) {
        this.notDataActions = notDataActions;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
