// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * State of the deployment stack.
 */
public final class DeploymentStackProvisioningState extends ExpandableStringEnum<DeploymentStackProvisioningState> {
    /**
     * Static value creating for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState CREATING = fromString("creating");

    /**
     * Static value validating for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState VALIDATING = fromString("validating");

    /**
     * Static value waiting for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState WAITING = fromString("waiting");

    /**
     * Static value deploying for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState DEPLOYING = fromString("deploying");

    /**
     * Static value canceling for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState CANCELING = fromString("canceling");

    /**
     * Static value updatingDenyAssignments for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState UPDATING_DENY_ASSIGNMENTS
        = fromString("updatingDenyAssignments");

    /**
     * Static value deletingResources for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState DELETING_RESOURCES = fromString("deletingResources");

    /**
     * Static value succeeded for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState SUCCEEDED = fromString("succeeded");

    /**
     * Static value failed for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState FAILED = fromString("failed");

    /**
     * Static value canceled for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState CANCELED = fromString("canceled");

    /**
     * Static value deleting for DeploymentStackProvisioningState.
     */
    public static final DeploymentStackProvisioningState DELETING = fromString("deleting");

    /**
     * Creates a new instance of DeploymentStackProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public DeploymentStackProvisioningState() {
    }

    /**
     * Creates or finds a DeploymentStackProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding DeploymentStackProvisioningState.
     */
    @JsonCreator
    public static DeploymentStackProvisioningState fromString(String name) {
        return fromString(name, DeploymentStackProvisioningState.class);
    }

    /**
     * Gets known DeploymentStackProvisioningState values.
     * 
     * @return known DeploymentStackProvisioningState values.
     */
    public static Collection<DeploymentStackProvisioningState> values() {
        return values(DeploymentStackProvisioningState.class);
    }
}
