// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Details about the change resource.
 */
@Immutable
public final class ChangeAttributes {
    /*
     * The ARM correlation ID of the change resource
     */
    @JsonProperty(value = "correlationId", access = JsonProperty.Access.WRITE_ONLY)
    private String correlationId;

    /*
     * The time the change(s) on the target resource ocurred
     */
    @JsonProperty(value = "timestamp", access = JsonProperty.Access.WRITE_ONLY)
    private String timestamp;

    /*
     * The number of changes this resource captures
     */
    @JsonProperty(value = "changesCount", access = JsonProperty.Access.WRITE_ONLY)
    private Long changesCount;

    /*
     * The GUID of the previous snapshot
     */
    @JsonProperty(value = "previousResourceSnapshotId", access = JsonProperty.Access.WRITE_ONLY)
    private String previousResourceSnapshotId;

    /*
     * The GUID of the new snapshot
     */
    @JsonProperty(value = "newResourceSnapshotId", access = JsonProperty.Access.WRITE_ONLY)
    private String newResourceSnapshotId;

    /**
     * Creates an instance of ChangeAttributes class.
     */
    public ChangeAttributes() {
    }

    /**
     * Get the correlationId property: The ARM correlation ID of the change resource.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Get the timestamp property: The time the change(s) on the target resource ocurred.
     * 
     * @return the timestamp value.
     */
    public String timestamp() {
        return this.timestamp;
    }

    /**
     * Get the changesCount property: The number of changes this resource captures.
     * 
     * @return the changesCount value.
     */
    public Long changesCount() {
        return this.changesCount;
    }

    /**
     * Get the previousResourceSnapshotId property: The GUID of the previous snapshot.
     * 
     * @return the previousResourceSnapshotId value.
     */
    public String previousResourceSnapshotId() {
        return this.previousResourceSnapshotId;
    }

    /**
     * Get the newResourceSnapshotId property: The GUID of the new snapshot.
     * 
     * @return the newResourceSnapshotId value.
     */
    public String newResourceSnapshotId() {
        return this.newResourceSnapshotId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
