// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Availability zone mappings for the region.
 */
@Immutable
public final class AvailabilityZoneMappings {
    /*
     * The logical zone id for the availability zone
     */
    @JsonProperty(value = "logicalZone", access = JsonProperty.Access.WRITE_ONLY)
    private String logicalZone;

    /*
     * The fully qualified physical zone id of availability zone to which logical zone id is mapped to
     */
    @JsonProperty(value = "physicalZone", access = JsonProperty.Access.WRITE_ONLY)
    private String physicalZone;

    /**
     * Creates an instance of AvailabilityZoneMappings class.
     */
    public AvailabilityZoneMappings() {
    }

    /**
     * Get the logicalZone property: The logical zone id for the availability zone.
     * 
     * @return the logicalZone value.
     */
    public String logicalZone() {
        return this.logicalZone;
    }

    /**
     * Get the physicalZone property: The fully qualified physical zone id of availability zone to which logical zone id
     * is mapped to.
     * 
     * @return the physicalZone value.
     */
    public String physicalZone() {
        return this.physicalZone;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
