/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.models.ParameterDefinitionsValue;
import com.azure.resourcemanager.resources.models.PolicyDefinitionGroup;
import com.azure.resourcemanager.resources.models.PolicyDefinitionReference;
import com.azure.resourcemanager.resources.models.PolicyType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class PolicySetDefinitionProperties {
    @JsonProperty(value="policyType")
    private PolicyType policyType;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="metadata")
    private Object metadata;
    @JsonProperty(value="parameters")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, ParameterDefinitionsValue> parameters;
    @JsonProperty(value="policyDefinitions", required=true)
    private List<PolicyDefinitionReference> policyDefinitions;
    @JsonProperty(value="policyDefinitionGroups")
    private List<PolicyDefinitionGroup> policyDefinitionGroups;
    private static final ClientLogger LOGGER = new ClientLogger(PolicySetDefinitionProperties.class);

    public PolicyType policyType() {
        return this.policyType;
    }

    public PolicySetDefinitionProperties withPolicyType(PolicyType policyType) {
        this.policyType = policyType;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public PolicySetDefinitionProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public PolicySetDefinitionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public Object metadata() {
        return this.metadata;
    }

    public PolicySetDefinitionProperties withMetadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, ParameterDefinitionsValue> parameters() {
        return this.parameters;
    }

    public PolicySetDefinitionProperties withParameters(Map<String, ParameterDefinitionsValue> parameters) {
        this.parameters = parameters;
        return this;
    }

    public List<PolicyDefinitionReference> policyDefinitions() {
        return this.policyDefinitions;
    }

    public PolicySetDefinitionProperties withPolicyDefinitions(List<PolicyDefinitionReference> policyDefinitions) {
        this.policyDefinitions = policyDefinitions;
        return this;
    }

    public List<PolicyDefinitionGroup> policyDefinitionGroups() {
        return this.policyDefinitionGroups;
    }

    public PolicySetDefinitionProperties withPolicyDefinitionGroups(List<PolicyDefinitionGroup> policyDefinitionGroups) {
        this.policyDefinitionGroups = policyDefinitionGroups;
        return this;
    }

    public void validate() {
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.policyDefinitions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property policyDefinitions in model PolicySetDefinitionProperties"));
        }
        this.policyDefinitions().forEach(e -> e.validate());
        if (this.policyDefinitionGroups() != null) {
            this.policyDefinitionGroups().forEach(e -> e.validate());
        }
    }
}

