// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.resources.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.resources.models.AssignmentScopeValidation;
import com.azure.resourcemanager.resources.models.ResourceSelector;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The policy exemption properties for Patch request.
 */
@Fluent
public final class PolicyExemptionUpdateProperties {
    /*
     * The resource selector list to filter policies by resource properties.
     */
    @JsonProperty(value = "resourceSelectors")
    private List<ResourceSelector> resourceSelectors;

    /*
     * The option whether validate the exemption is at or under the assignment scope.
     */
    @JsonProperty(value = "assignmentScopeValidation")
    private AssignmentScopeValidation assignmentScopeValidation;

    /**
     * Creates an instance of PolicyExemptionUpdateProperties class.
     */
    public PolicyExemptionUpdateProperties() {
    }

    /**
     * Get the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @return the resourceSelectors value.
     */
    public List<ResourceSelector> resourceSelectors() {
        return this.resourceSelectors;
    }

    /**
     * Set the resourceSelectors property: The resource selector list to filter policies by resource properties.
     * 
     * @param resourceSelectors the resourceSelectors value to set.
     * @return the PolicyExemptionUpdateProperties object itself.
     */
    public PolicyExemptionUpdateProperties withResourceSelectors(List<ResourceSelector> resourceSelectors) {
        this.resourceSelectors = resourceSelectors;
        return this;
    }

    /**
     * Get the assignmentScopeValidation property: The option whether validate the exemption is at or under the
     * assignment scope.
     * 
     * @return the assignmentScopeValidation value.
     */
    public AssignmentScopeValidation assignmentScopeValidation() {
        return this.assignmentScopeValidation;
    }

    /**
     * Set the assignmentScopeValidation property: The option whether validate the exemption is at or under the
     * assignment scope.
     * 
     * @param assignmentScopeValidation the assignmentScopeValidation value to set.
     * @return the PolicyExemptionUpdateProperties object itself.
     */
    public PolicyExemptionUpdateProperties
        withAssignmentScopeValidation(AssignmentScopeValidation assignmentScopeValidation) {
        this.assignmentScopeValidation = assignmentScopeValidation;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (resourceSelectors() != null) {
            resourceSelectors().forEach(e -> e.validate());
        }
    }
}
